/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.intellij.ui.components.JBPanel;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class StageView<T extends Stage>
extends AspectObserver {
    private final T myStage;
    private final JPanel myComponent;
    private final StudioProfilersView myProfilersView;
    private final JPanel myTooltipPanel;
    private TooltipView myActiveTooltipView;
    private final ViewBinder<StageView, TooltipModel, TooltipView> myTooltipBinder;
    @NotNull
    private final JLabel mySelectionTimeLabel;

    public StageView(@NotNull StudioProfilersView profilersView, @NotNull T stage) {
        if (profilersView == null) {
            StageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            StageView.$$$reportNull$$$0(1);
        }
        this.myProfilersView = profilersView;
        this.myStage = stage;
        this.myComponent = new JBPanel((LayoutManager)new BorderLayout());
        this.myComponent.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myTooltipPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.myTooltipPanel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myTooltipBinder = new ViewBinder();
        this.mySelectionTimeLabel = this.createSelectionTimeLabel();
        ((Stage)((Object)stage)).getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.TOOLTIP, this::tooltipChanged);
        ((Stage)((Object)stage)).getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::selectionChanged);
        this.selectionChanged();
    }

    @NotNull
    public T getStage() {
        T t = this.myStage;
        if (t == null) {
            StageView.$$$reportNull$$$0(2);
        }
        return t;
    }

    @NotNull
    public StudioProfilersView getProfilersView() {
        StudioProfilersView studioProfilersView = this.myProfilersView;
        if (studioProfilersView == null) {
            StageView.$$$reportNull$$$0(3);
        }
        return studioProfilersView;
    }

    @NotNull
    public IdeProfilerComponents getIdeComponents() {
        IdeProfilerComponents ideProfilerComponents = this.myProfilersView.getIdeProfilerComponents();
        if (ideProfilerComponents == null) {
            StageView.$$$reportNull$$$0(4);
        }
        return ideProfilerComponents;
    }

    @NotNull
    public final JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            StageView.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public ViewBinder<StageView, TooltipModel, TooltipView> getTooltipBinder() {
        return this.myTooltipBinder;
    }

    public JPanel getTooltipPanel() {
        return this.myTooltipPanel;
    }

    @NotNull
    public JLabel getSelectionTimeLabel() {
        JLabel jLabel = this.mySelectionTimeLabel;
        if (jLabel == null) {
            StageView.$$$reportNull$$$0(6);
        }
        return jLabel;
    }

    @NotNull
    protected JComponent buildTimeAxis(StudioProfilers profilers) {
        JPanel axisPanel = new JPanel(new BorderLayout());
        axisPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        AxisComponent timeAxis = new AxisComponent(profilers.getViewAxis(), AxisComponent.AxisOrientation.BOTTOM, true);
        timeAxis.setShowAxisLine(false);
        timeAxis.setMinimumSize(new Dimension(0, ProfilerLayout.TIME_AXIS_HEIGHT));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, ProfilerLayout.TIME_AXIS_HEIGHT));
        axisPanel.add((Component)timeAxis, "Center");
        JPanel jPanel = axisPanel;
        if (jPanel == null) {
            StageView.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public abstract JComponent getToolbar();

    public boolean isToolbarVisible() {
        return true;
    }

    public boolean supportsStreaming() {
        return ((Stage)((Object)this.getStage())).getTimeline() instanceof StreamingTimeline;
    }

    public boolean supportsStageNavigation() {
        return ((Stage)((Object)this.getStage())).getStudioProfilers().getSession().getPid() != 0;
    }

    public boolean needsProcessSelection() {
        return false;
    }

    protected void tooltipChanged() {
        if (this.myActiveTooltipView != null) {
            this.myActiveTooltipView.dispose();
            this.myActiveTooltipView = null;
        }
        this.myTooltipPanel.removeAll();
        this.myTooltipPanel.setVisible(false);
        if (((Stage)((Object)this.myStage)).getTooltip() != null) {
            this.myActiveTooltipView = (TooltipView)this.myTooltipBinder.build((Object)this, (Object)((Stage)((Object)this.myStage)).getTooltip());
            this.myTooltipPanel.add(this.myActiveTooltipView.createComponent());
            this.myTooltipPanel.setVisible(true);
        }
        this.myTooltipPanel.invalidate();
        this.myTooltipPanel.repaint();
    }

    private void selectionChanged() {
        StreamingTimeline timeline = ((Stage)((Object)this.myStage)).getStudioProfilers().getTimeline();
        Range selectionRange = timeline.getSelectionRange();
        if (selectionRange.isEmpty()) {
            this.mySelectionTimeLabel.setIcon(null);
            this.mySelectionTimeLabel.setText("");
            return;
        }
        long selectionMinUs = timeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMin()));
        long selectionMaxUs = timeline.convertToRelativeTimeUs(TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMax()));
        this.mySelectionTimeLabel.setIcon(StudioIcons.Profiler.Toolbar.CLOCK);
        if (selectionRange.isPoint()) {
            this.mySelectionTimeLabel.setText(TimeFormatter.getSimplifiedClockString((long)selectionMinUs));
        } else {
            this.mySelectionTimeLabel.setText(String.format("%s - %s", TimeFormatter.getSimplifiedClockString((long)selectionMinUs), TimeFormatter.getSimplifiedClockString((long)selectionMaxUs)));
        }
    }

    @NotNull
    private JLabel createSelectionTimeLabel() {
        JLabel selectionTimeLabel = new JLabel("");
        selectionTimeLabel.setFont(ProfilerFonts.STANDARD_FONT);
        selectionTimeLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        selectionTimeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object timeline = ((Stage)((Object)StageView.this.getStage())).getTimeline();
                timeline.frameViewToRange(timeline.getSelectionRange());
            }
        });
        selectionTimeLabel.setToolTipText("Selected range");
        selectionTimeLabel.setCursor(Cursor.getPredefinedCursor(12));
        JLabel jLabel = selectionTimeLabel;
        if (jLabel == null) {
            StageView.$$$reportNull$$$0(8);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/StageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/StageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilersView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionTimeLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTimeAxis";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectionTimeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

