/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorTooltip;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StudioMonitorStage
extends StreamingStage {
    @NotNull
    private final List<ProfilerMonitor> myMonitors;

    public StudioMonitorStage(@NotNull StudioProfilers profiler) {
        if (profiler == null) {
            StudioMonitorStage.$$$reportNull$$$0(0);
        }
        super(profiler);
        this.myMonitors = new LinkedList<ProfilerMonitor>();
    }

    @Override
    public void enter() {
        this.logEnterStage();
        this.getTimeline().getSelectionRange().clear();
        Common.Session session = this.getStudioProfilers().getSession();
        if (session != Common.Session.getDefaultInstance()) {
            SupportLevel supportLevel = this.getStudioProfilers().getSelectedSessionSupportLevel();
            for (StudioProfiler profiler : this.getStudioProfilers().getProfilers()) {
                if (!supportLevel.isMonitorSupported(profiler)) continue;
                this.myMonitors.add(profiler.newMonitor());
            }
        }
        this.myMonitors.forEach(ProfilerMonitor::enter);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
    }

    @Override
    public void exit() {
        this.myMonitors.forEach(ProfilerMonitor::exit);
        this.myMonitors.clear();
    }

    @NotNull
    public List<ProfilerMonitor> getMonitors() {
        List<ProfilerMonitor> list = this.myMonitors;
        if (list == null) {
            StudioMonitorStage.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setTooltip(TooltipModel tooltip) {
        super.setTooltip(tooltip);
        this.myMonitors.forEach(monitor -> monitor.setFocus(this.getTooltip() instanceof ProfilerMonitorTooltip && ((ProfilerMonitorTooltip)this.getTooltip()).getMonitor() == monitor));
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.OVERVIEW_STAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/StudioMonitorStage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/StudioMonitorStage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMonitors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

