/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.StatusPanelModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureHandler
implements Updatable,
StatusPanelModel {
    @NotNull
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final Range myParseRange;
    @NotNull
    private final IdeProfilerServices myServices;
    @NotNull
    private final ProfilingConfiguration myConfiguration;
    @NotNull
    private final File myCaptureFile;
    private final long myTraceId;
    private final int myCaptureProcessIdHint;
    @Nullable
    private final String myCaptureProcessNameHint;
    private boolean myIsParsing;

    /*
     * WARNING - void declaration
     */
    public CpuCaptureHandler(@NotNull IdeProfilerServices services, @NotNull File captureFile, long traceId, @NotNull ProfilingConfiguration configuration, @Nullable String captureProcessNameHint, int n) {
        void captureProcessIdHint;
        if (services == null) {
            CpuCaptureHandler.$$$reportNull$$$0(0);
        }
        if (captureFile == null) {
            CpuCaptureHandler.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CpuCaptureHandler.$$$reportNull$$$0(2);
        }
        this.myParseRange = new Range();
        this.myIsParsing = false;
        this.myCaptureParser = new CpuCaptureParser(services);
        this.myCaptureFile = captureFile;
        this.myTraceId = traceId;
        this.myServices = services;
        this.myConfiguration = configuration;
        this.myCaptureProcessIdHint = captureProcessIdHint;
        this.myCaptureProcessNameHint = captureProcessNameHint;
        this.myCaptureParser.trackCaptureMetadata(traceId, new CpuCaptureMetadata(configuration));
    }

    @Override
    @NotNull
    public Range getRange() {
        Range range = this.myParseRange;
        if (range == null) {
            CpuCaptureHandler.$$$reportNull$$$0(3);
        }
        return range;
    }

    @Override
    @NotNull
    public String getConfigurationText() {
        String string = this.myConfiguration.getName();
        if (string == null) {
            CpuCaptureHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void abort() {
        this.myCaptureParser.abortParsing();
    }

    public void update(long elapsedNs) {
        if (this.myIsParsing) {
            this.myParseRange.setMax(this.myParseRange.getMax() + (double)elapsedNs);
        }
    }

    public void parse(Consumer<CpuCapture> captureCompleted) {
        this.myIsParsing = true;
        this.myParseRange.set(0.0, 0.0);
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.myCaptureFile, this.myTraceId, this.myConfiguration.getTraceType(), this.myCaptureProcessIdHint, this.myCaptureProcessNameHint);
        capture.handleAsync((parsedCapture, exception) -> {
            this.myIsParsing = false;
            captureCompleted.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.myServices.getMainExecutor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

