/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureMetadata {
    @Nullable
    private CaptureStatus myStatus;
    private long myCaptureDurationMs;
    private long myRecordDurationMs;
    private int myTraceFileSizeBytes;
    private long myParsingTimeMs;
    private int myStoppingTimeMs;
    @Nullable
    private Boolean myHasComposeTracingNodes;
    @NotNull
    private ProfilingConfiguration myProfilingConfiguration;

    public CpuCaptureMetadata(@NotNull ProfilingConfiguration configuration) {
        if (configuration == null) {
            CpuCaptureMetadata.$$$reportNull$$$0(0);
        }
        this.myProfilingConfiguration = configuration;
    }

    @Nullable
    public CaptureStatus getStatus() {
        return this.myStatus;
    }

    public void setStatus(CaptureStatus status) {
        this.myStatus = status;
    }

    public int getTraceFileSizeBytes() {
        return this.myTraceFileSizeBytes;
    }

    public void setTraceFileSizeBytes(int traceFileSizeBytes) {
        this.myTraceFileSizeBytes = traceFileSizeBytes;
    }

    public long getCaptureDurationMs() {
        return this.myCaptureDurationMs;
    }

    public void setCaptureDurationMs(long captureDurationMs) {
        this.myCaptureDurationMs = captureDurationMs;
    }

    public int getStoppingTimeMs() {
        return this.myStoppingTimeMs;
    }

    public void setStoppingTimeMs(int stoppingTimeMs) {
        this.myStoppingTimeMs = stoppingTimeMs;
    }

    @Nullable
    public Boolean getHasComposeTracingNodes() {
        return this.myHasComposeTracingNodes;
    }

    public void setHasComposeTracingNodes(@Nullable Boolean hasComposeTracingNodes) {
        this.myHasComposeTracingNodes = hasComposeTracingNodes;
    }

    public long getParsingTimeMs() {
        return this.myParsingTimeMs;
    }

    public void setParsingTimeMs(long parsingTimeMs) {
        this.myParsingTimeMs = parsingTimeMs;
    }

    public long getRecordDurationMs() {
        return this.myRecordDurationMs;
    }

    public void setRecordDurationMs(long recordDurationMs) {
        this.myRecordDurationMs = recordDurationMs;
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        ProfilingConfiguration profilingConfiguration = this.myProfilingConfiguration;
        if (profilingConfiguration == null) {
            CpuCaptureMetadata.$$$reportNull$$$0(1);
        }
        return profilingConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureMetadata";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum CaptureStatus {
        SUCCESS,
        STOP_CAPTURING_FAILURE,
        PARSING_FAILURE,
        USER_ABORTED_PARSING,
        PREPROCESS_FAILURE,
        STOP_FAILED_NO_GOING_PROFILING,
        STOP_FAILED_APP_PROCESS_DIED,
        STOP_FAILED_APP_PID_CHANGED,
        STOP_FAILED_PROFILER_PROCESS_DIED,
        STOP_FAILED_STOP_COMMAND_FAILED,
        STOP_FAILED_STILL_PROFILING_AFTER_STOP,
        STOP_FAILED_CANNOT_START_WAITING,
        STOP_FAILED_WAIT_TIMEOUT,
        STOP_FAILED_WAIT_FAILED,
        STOP_FAILED_CANNOT_READ_WAIT_EVENT,
        STOP_FAILED_CANNOT_COPY_FILE,
        STOP_FAILED_CANNOT_FORM_FILE,
        STOP_FAILED_CANNOT_READ_FILE,
        PARSING_FAILED_PATH_INVALID,
        PARSING_FAILED_READ_ERROR,
        PARSING_FAILED_PARSER_UNKNOWN,
        PARSING_FAILED_FILE_HEADER_ERROR,
        PARSING_FAILED_PARSER_ERROR,
        PARSING_FAILED_CAUSE_UNKNOWN;


        public static CaptureStatus fromStopStatus(Trace.TraceStopStatus.Status status) {
            switch (status) {
                case NO_ONGOING_PROFILING: {
                    return STOP_FAILED_NO_GOING_PROFILING;
                }
                case APP_PROCESS_DIED: {
                    return STOP_FAILED_APP_PROCESS_DIED;
                }
                case APP_PID_CHANGED: {
                    return STOP_FAILED_APP_PID_CHANGED;
                }
                case PROFILER_PROCESS_DIED: {
                    return STOP_FAILED_PROFILER_PROCESS_DIED;
                }
                case STOP_COMMAND_FAILED: {
                    return STOP_FAILED_STOP_COMMAND_FAILED;
                }
                case STILL_PROFILING_AFTER_STOP: {
                    return STOP_FAILED_STILL_PROFILING_AFTER_STOP;
                }
                case CANNOT_START_WAITING: {
                    return STOP_FAILED_CANNOT_START_WAITING;
                }
                case WAIT_TIMEOUT: {
                    return STOP_FAILED_WAIT_TIMEOUT;
                }
                case WAIT_FAILED: {
                    return STOP_FAILED_WAIT_FAILED;
                }
                case CANNOT_READ_WAIT_EVENT: {
                    return STOP_FAILED_CANNOT_READ_WAIT_EVENT;
                }
                case CANNOT_COPY_FILE: {
                    return STOP_FAILED_CANNOT_COPY_FILE;
                }
                case CANNOT_FORM_FILE: {
                    return STOP_FAILED_CANNOT_FORM_FILE;
                }
                case CANNOT_READ_FILE: {
                    return STOP_FAILED_CANNOT_READ_FILE;
                }
            }
            return SUCCESS;
        }
    }
}

