/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.CpuUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureMinimapModel {
    @NotNull
    private final Range myCaptureRange;
    @NotNull
    private final RangeSelectionModel myRangeSelectionModel;
    @NotNull
    private final CpuUsage myCpuUsage;

    public CpuCaptureMinimapModel(@NotNull StudioProfilers profilers, @NotNull CpuCapture cpuCapture, @NotNull Range selectionRange) {
        if (profilers == null) {
            CpuCaptureMinimapModel.$$$reportNull$$$0(0);
        }
        if (cpuCapture == null) {
            CpuCaptureMinimapModel.$$$reportNull$$$0(1);
        }
        if (selectionRange == null) {
            CpuCaptureMinimapModel.$$$reportNull$$$0(2);
        }
        this.myCaptureRange = cpuCapture.getRange();
        Range initialCaptureViewRange = cpuCapture.getTimeline().getViewRange();
        this.myCpuUsage = new CpuUsage(profilers, this.myCaptureRange, this.myCaptureRange, cpuCapture);
        this.myRangeSelectionModel = new RangeSelectionModel(selectionRange, new Range(this.myCaptureRange));
        this.myRangeSelectionModel.addConstraint(new DurationDataModel(new RangedSeries(this.myCaptureRange, (DataSeries)new DataSeries<CpuTraceInfo>(){

            public List<SeriesData<CpuTraceInfo>> getDataForRange(Range range) {
                ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
                if (CpuCaptureMinimapModel.this.myCaptureRange.intersectsWith(range)) {
                    CpuTraceInfo traceInfo = new CpuTraceInfo(Trace.TraceInfo.newBuilder().setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)CpuCaptureMinimapModel.this.myCaptureRange.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)CpuCaptureMinimapModel.this.myCaptureRange.getMax())).build());
                    seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)traceInfo.getRange().getMin(), (Object)traceInfo));
                }
                return seriesData;
            }
        })));
        this.myRangeSelectionModel.set(initialCaptureViewRange.getMin(), initialCaptureViewRange.getMax());
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        RangeSelectionModel rangeSelectionModel2 = this.myRangeSelectionModel;
        if (rangeSelectionModel2 == null) {
            CpuCaptureMinimapModel.$$$reportNull$$$0(3);
        }
        return rangeSelectionModel2;
    }

    @NotNull
    public CpuUsage getCpuUsage() {
        CpuUsage cpuUsage = this.myCpuUsage;
        if (cpuUsage == null) {
            CpuCaptureMinimapModel.$$$reportNull$$$0(4);
        }
        return cpuUsage;
    }

    @NotNull
    public Range getCaptureRange() {
        Range range = this.myCaptureRange;
        if (range == null) {
            CpuCaptureMinimapModel.$$$reportNull$$$0(5);
        }
        return range;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuCapture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureMinimapModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureMinimapModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeSelectionModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuUsage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

