/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCaptureMinimapModel;
import com.android.tools.profilers.cpu.CpuUsage;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureMinimapView {
    private static final int RANGE_SELECTION_DRAG_BAR_HEIGHT = 16;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final JPanel myInnerPanel;

    public CpuCaptureMinimapView(@NotNull CpuCaptureMinimapModel model) {
        if (model == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(0);
        }
        this.myInnerPanel = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        this.myInnerPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        this.myInnerPanel.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)1, (int)0, (int)1));
        JLabel chartLabel = new JLabel();
        chartLabel.setText("CPU Usage");
        chartLabel.setFont(ProfilerFonts.SMALL_FONT);
        chartLabel.setVerticalAlignment(1);
        chartLabel.setBorder((Border)new JBEmptyBorder(4, 4, 4, 4));
        RangeSelectionComponent rangeSelectionComponent = CpuCaptureMinimapView.createRangeSelectionComponent(model.getRangeSelectionModel());
        this.myInnerPanel.add((Component)this.createOverlayComponent((JComponent)rangeSelectionComponent), new TabularLayout.Constraint(0, 0));
        this.myInnerPanel.add((Component)rangeSelectionComponent, new TabularLayout.Constraint(0, 0));
        this.myInnerPanel.add((Component)CpuCaptureMinimapView.createAxis(model.getCaptureRange()), new TabularLayout.Constraint(0, 0));
        this.myInnerPanel.add((Component)CpuCaptureMinimapView.createLineChart(model.getCpuUsage()), new TabularLayout.Constraint(0, 0));
        this.myInnerPanel.add((Component)chartLabel, new TabularLayout.Constraint(0, 0));
        if (model.getCpuUsage().getCpuSeries().getSeries().isEmpty()) {
            JLabel cpuDataNotAvailableLabel = new JLabel();
            cpuDataNotAvailableLabel.setText("No CPU usage data available for this imported trace");
            cpuDataNotAvailableLabel.setFont(ProfilerFonts.H3_FONT);
            cpuDataNotAvailableLabel.setVerticalAlignment(0);
            cpuDataNotAvailableLabel.setHorizontalAlignment(0);
            this.myInnerPanel.add((Component)cpuDataNotAvailableLabel, new TabularLayout.Constraint(0, 0));
        }
        this.myPanel = new JPanel((LayoutManager)new TabularLayout("*", "60px"));
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        this.myPanel.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.myPanel.add((Component)this.myInnerPanel, new TabularLayout.Constraint(0, 0));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void registerRangeTooltipComponent(@NotNull RangeTooltipComponent tooltipComponent) {
        if (tooltipComponent == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(2);
        }
        tooltipComponent.registerListenersOn((JComponent)this.myInnerPanel);
    }

    public void addMouseListener(@NotNull MouseListener listener2) {
        if (listener2 == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(3);
        }
        this.myInnerPanel.addMouseListener(listener2);
    }

    private JComponent createOverlayComponent(@NotNull JComponent component) {
        if (component == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(4);
        }
        OverlayComponent overlayComponent = new OverlayComponent((Component)component);
        DelegateMouseEventHandler.delegateTo((Component)this.myInnerPanel).installListenerOn((Component)overlayComponent).installMotionListenerOn((Component)overlayComponent);
        return overlayComponent;
    }

    private static RangeSelectionComponent createRangeSelectionComponent(@NotNull RangeSelectionModel model) {
        if (model == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(5);
        }
        RangeSelectionComponent rangeSelectionComponent = new RangeSelectionComponent(model, true);
        rangeSelectionComponent.setCursorSetter(AdtUiUtils::setTooltipCursor);
        rangeSelectionComponent.setDragBarHeight(16);
        return rangeSelectionComponent;
    }

    private static JComponent createLineChart(@NotNull CpuUsage cpuUsage) {
        if (cpuUsage == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(6);
        }
        LineChart lineChart = new LineChart((LineChartModel)cpuUsage);
        lineChart.configure(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE).setFilled(true));
        lineChart.setFillEndGap(true);
        return lineChart;
    }

    private static JComponent createAxis(@NotNull Range cpuUsageRange) {
        if (cpuUsageRange == null) {
            CpuCaptureMinimapView.$$$reportNull$$$0(7);
        }
        AxisComponent timeAxis = new AxisComponent((AxisComponentModel)new ClampedAxisComponentModel.Builder(cpuUsageRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).build(), AxisComponent.AxisOrientation.TOP, true);
        timeAxis.setMinimumSize(new Dimension(0, ProfilerLayout.TIME_AXIS_HEIGHT));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, ProfilerLayout.TIME_AXIS_HEIGHT));
        timeAxis.setShowAxisLine(false);
        return timeAxis;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureMinimapView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuUsage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuUsageRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureMinimapView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeTooltipComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOverlayComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRangeSelectionComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLineChart";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAxis";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

