/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.config.ImportedConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AtraceExporter;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.transporteventutils.TransportUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfiler
implements StudioProfiler {
    @NotNull
    private final StudioProfilers profilers;

    public CpuProfiler(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(0);
        }
        this.profilers = profilers;
        this.registerImportedSessionListener();
        this.registerTraceImportHandler();
    }

    private void onImportSessionSelected() {
        this.profilers.getIdeServices().runAsync(() -> CpuCaptureStage.create(this.profilers, new ImportedConfiguration(), this.profilers.getSession().getStartTimestamp()), captureStage -> {
            if (captureStage != null) {
                this.profilers.getIdeServices().getMainExecutor().execute(() -> this.profilers.setStage((Stage)((Object)captureStage)));
            } else {
                this.profilers.getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
            }
        });
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfiler.class);
    }

    private void registerImportedSessionListener() {
        this.profilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.CPU_CAPTURE, this::onImportSessionSelected);
    }

    private void registerTraceImportHandler() {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        sessionsManager.registerImportHandler("trace", this::loadCapture);
        sessionsManager.registerImportHandler("pftrace", this::loadCapture);
        sessionsManager.registerImportHandler("perfetto-trace", this::loadCapture);
    }

    private void loadCapture(File file) {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        long startTimestampEpochMs = System.currentTimeMillis();
        Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
        long startTimestampNs = (Long)timestampsNs.first;
        if (sessionsManager.setSessionById(startTimestampNs)) {
            return;
        }
        long endTimestampNs = (Long)timestampsNs.second;
        try {
            byte[] fileBytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            Map<String, ByteString> byteCacheMap = Collections.singletonMap(String.valueOf(startTimestampNs), ByteString.copyFrom((byte[])fileBytes));
            sessionsManager.createImportedSession(file.getName(), Common.SessionData.SessionStarted.SessionType.CPU_CAPTURE, startTimestampNs, endTimestampNs, startTimestampEpochMs, byteCacheMap, new Common.Event[0]);
        }
        catch (IOException ex) {
            CpuProfiler.getLogger().warn("Importing Session Failed: cannot read from " + file.getPath());
            return;
        }
        this.profilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.CPU_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    @Override
    @NotNull
    public ProfilerMonitor newMonitor() {
        return new CpuMonitor(this.profilers);
    }

    @Override
    public void startProfiling(@NotNull Common.Session session) {
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void stopProfiling(@NotNull Common.Session session) {
        List<Trace.TraceInfo> traces;
        Trace.TraceInfo mostRecentTrace;
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(2);
        }
        Trace.TraceInfo traceInfo = mostRecentTrace = (traces = CpuProfiler.getTraceInfoFromSession(this.profilers.getClient(), session)).isEmpty() ? null : traces.get(traces.size() - 1);
        if (mostRecentTrace != null && mostRecentTrace.getToTimestamp() == -1L) {
            CpuProfiler.stopTracing(this.profilers, session, mostRecentTrace.getConfiguration(), null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void saveCaptureToFile(@NotNull StudioProfilers profilers, @NotNull Trace.TraceInfo info, @NotNull OutputStream outputStream) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(3);
        }
        if (info == null) {
            CpuProfiler.$$$reportNull$$$0(4);
        }
        if (outputStream == null) {
            CpuProfiler.$$$reportNull$$$0(5);
        }
        try {
            Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setId(String.valueOf(info.getTraceId())).build();
            Transport.BytesResponse traceResponse = profilers.getClient().getTransportClient().getBytes(traceRequest);
            if (ProfilingConfiguration.TraceType.from(info.getConfiguration()) == ProfilingConfiguration.TraceType.ATRACE) {
                File trace = FileUtil.createTempFile((String)String.format("cpu_trace_%d", info.getTraceId()), (String)".trace", (boolean)true);
                try (FileOutputStream out = new FileOutputStream(trace);){
                    out.write(traceResponse.getContents().toByteArray());
                }
                AtraceExporter.export(trace, outputStream);
                return;
            }
            FileUtil.copy((InputStream)new ByteArrayInputStream(traceResponse.getContents().toByteArray()), (OutputStream)outputStream);
            if (ProfilingConfiguration.TraceType.from(info.getConfiguration()) != ProfilingConfiguration.TraceType.PERFETTO) return;
        }
        catch (IOException exception) {
            CpuProfiler.getLogger().warn("Failed to export CPU trace file:\n" + exception);
        }
    }

    @NotNull
    static String generateCaptureFileName(@NotNull ProfilingConfiguration.TraceType profilerType) {
        if (profilerType == null) {
            CpuProfiler.$$$reportNull$$$0(6);
        }
        StringBuilder traceName = new StringBuilder(String.format("cpu-%s-", StringUtil.toLowerCase((String)profilerType.name())));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        traceName.append(LocalDateTime.now().format(formatter));
        String string = traceName.toString();
        if (string == null) {
            CpuProfiler.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static List<Trace.TraceInfo> getTraceInfoFromRange(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        if (client == null) {
            CpuProfiler.$$$reportNull$$$0(8);
        }
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(9);
        }
        if (rangeUs == null) {
            CpuProfiler.$$$reportNull$$$0(10);
        }
        long rangeMinNs = rangeUs.getMin() == -9.223372036854776E18 ? Long.MIN_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long rangeMaxNs = rangeUs.getMax() == 9.223372036854776E18 ? Long.MAX_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.CPU_TRACE).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
        List<Trace.TraceInfo> list = response.getGroupsList().stream().map(group -> {
            Trace.TraceInfo info;
            Common.Event event = group.getEvents(group.getEventsCount() - 1);
            Trace.TraceInfo traceInfo = info = event.getTraceData().hasTraceStarted() ? event.getTraceData().getTraceStarted().getTraceInfo() : event.getTraceData().getTraceEnded().getTraceInfo();
            if (info.equals((Object)Trace.TraceInfo.getDefaultInstance())) {
                assert (group.getEventsCount() > 1);
                info = group.getEvents(0).getTraceData().getTraceStarted().getTraceInfo();
                if (info.getToTimestamp() == -1L) {
                    info = info.toBuilder().setToTimestamp(session.getEndTimestamp()).setStopStatus(Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.APP_PROCESS_DIED)).build();
                }
            }
            return info;
        }).sorted(Comparator.comparingLong(Trace.TraceInfo::getFromTimestamp)).collect(Collectors.toList());
        if (list == null) {
            CpuProfiler.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static Trace.TraceInfo getTraceInfoFromId(@NotNull StudioProfilers profilers, long traceId) {
        Transport.GetEventGroupsResponse response;
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(12);
        }
        if ((response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.CPU_TRACE).setGroupId(traceId).build())).getGroupsCount() == 0) {
            Trace.TraceInfo traceInfo = Trace.TraceInfo.getDefaultInstance();
            if (traceInfo == null) {
                CpuProfiler.$$$reportNull$$$0(13);
            }
            return traceInfo;
        }
        Trace.TraceData data = response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1).getTraceData();
        if (data.hasTraceStarted()) {
            Trace.TraceInfo traceInfo = data.getTraceStarted().getTraceInfo();
            if (traceInfo == null) {
                CpuProfiler.$$$reportNull$$$0(14);
            }
            return traceInfo;
        }
        Trace.TraceInfo traceInfo = data.getTraceEnded().getTraceInfo();
        if (traceInfo == null) {
            CpuProfiler.$$$reportNull$$$0(15);
        }
        return traceInfo;
    }

    @NotNull
    public static List<Trace.TraceInfo> getTraceInfoFromSession(@NotNull ProfilerClient client, @NotNull Common.Session session) {
        if (client == null) {
            CpuProfiler.$$$reportNull$$$0(16);
        }
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(17);
        }
        return CpuProfiler.getTraceInfoFromRange(client, session, new Range(-9.223372036854776E18, 9.223372036854776E18));
    }

    @NotNull
    public static Common.Event getTraceStatusEventFromId(@NotNull StudioProfilers profilers, long traceId) {
        Transport.GetEventGroupsResponse response;
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(18);
        }
        if ((response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.TRACE_STATUS).setGroupId(traceId).build())).getGroupsCount() == 0) {
            Common.Event event = Common.Event.getDefaultInstance();
            if (event == null) {
                CpuProfiler.$$$reportNull$$$0(19);
            }
            return event;
        }
        Common.Event event = response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1);
        if (event == null) {
            CpuProfiler.$$$reportNull$$$0(20);
        }
        return event;
    }

    public static void startTracing(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Trace.TraceConfiguration configuration, @NotNull Consumer<Trace.TraceStartStatus> statusResponseHandler, @Nullable Consumer<Trace.TraceInfo> cpuTraceResponseHandler) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(21);
        }
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(22);
        }
        if (configuration == null) {
            CpuProfiler.$$$reportNull$$$0(23);
        }
        if (statusResponseHandler == null) {
            CpuProfiler.$$$reportNull$$$0(24);
        }
        Executor poolExecutor = profilers.getIdeServices().getPoolExecutor();
        Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setType(Commands.Command.CommandType.START_TRACE).setStartTrace(Trace.StartTrace.newBuilder().setProfilerType(Trace.ProfilerType.CPU).setConfiguration(configuration).build()).build();
        profilers.getClient().executeAsync(startCommand, poolExecutor).thenAcceptAsync(response -> {
            Function<Common.Event, Boolean> traceStatusEventCallback = event -> {
                statusResponseHandler.accept(event.getTraceStatus().getTraceStartStatus());
                return true;
            };
            TransportUtils.registerListener(profilers, Common.Event.Kind.TRACE_STATUS, session.getStreamId(), session.getPid(), response.getCommandId(), traceStatusEventCallback);
            if (cpuTraceResponseHandler != null) {
                Function<Common.Event, Boolean> cpuTraceEventCallback = event -> {
                    if (event.getTraceData().hasTraceStarted()) {
                        cpuTraceResponseHandler.accept(event.getTraceData().getTraceStarted().getTraceInfo());
                    }
                    return true;
                };
                TransportUtils.registerListener(profilers, Common.Event.Kind.CPU_TRACE, session.getStreamId(), session.getPid(), response.getCommandId(), cpuTraceEventCallback);
            }
        }, poolExecutor);
    }

    public static void stopTracing(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Trace.TraceConfiguration configuration, @Nullable Consumer<Trace.TraceStopStatus> statusResponseHandler, @Nullable Consumer<Trace.TraceInfo> cpuTraceResponseHandler) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(25);
        }
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(26);
        }
        if (configuration == null) {
            CpuProfiler.$$$reportNull$$$0(27);
        }
        Executor poolExecutor = profilers.getIdeServices().getPoolExecutor();
        Commands.Command stopCommand = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setType(Commands.Command.CommandType.STOP_TRACE).setStopTrace(Trace.StopTrace.newBuilder().setProfilerType(Trace.ProfilerType.CPU).setConfiguration(configuration).setNeedTraceResponse(statusResponseHandler != null)).build();
        profilers.getClient().executeAsync(stopCommand, poolExecutor).thenAcceptAsync(response -> {
            if (statusResponseHandler != null) {
                Function<Common.Event, Boolean> traceStatusEventCallback = event -> {
                    statusResponseHandler.accept(event.getTraceStatus().getTraceStopStatus());
                    return true;
                };
                TransportUtils.registerListener(profilers, Common.Event.Kind.TRACE_STATUS, session.getStreamId(), session.getPid(), response.getCommandId(), traceStatusEventCallback);
            }
            if (cpuTraceResponseHandler != null) {
                Function<Common.Event, Boolean> cpuTraceEventCallback = event -> {
                    if (event.getTraceData().hasTraceEnded()) {
                        cpuTraceResponseHandler.accept(event.getTraceData().getTraceEnded().getTraceInfo());
                    }
                    return true;
                };
                TransportUtils.registerListener(profilers, Common.Event.Kind.CPU_TRACE, session.getStreamId(), session.getPid(), response.getCommandId(), cpuTraceEventCallback);
            }
        }, poolExecutor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 13, 14, 15, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 17: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerType";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfiler";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeUs";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusResponseHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfiler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCaptureFileName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceInfoFromRange";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceInfoFromId";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceStatusEventFromId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startProfiling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stopProfiling";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveCaptureToFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateCaptureFileName";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTraceInfoFromRange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTraceInfoFromId";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTraceInfoFromSession";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTraceStatusEventFromId";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "startTracing";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "stopTracing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 13, 14, 15, 19, 20 -> new IllegalStateException(string);
        };
    }
}

