/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import org.jetbrains.annotations.NotNull;

public class CpuThreadInfo {
    public static final String RENDER_THREAD_NAME = "RenderThread";
    public static final String GPU_THREAD_NAME = "GPU completion";
    private final int myId;
    private final String myName;
    private final boolean myIsMainThread;

    public CpuThreadInfo(int threadId, String name, boolean isMainThread) {
        this.myId = threadId;
        this.myName = name;
        this.myIsMainThread = isMainThread;
    }

    public CpuThreadInfo(int threadId, String name) {
        this(threadId, name, false);
    }

    public int getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CpuThreadInfo.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isMainThread() {
        return this.myIsMainThread;
    }

    public boolean isRenderThread() {
        return this.getName().equals(RENDER_THREAD_NAME);
    }

    public boolean isGpuThread() {
        return this.getName().equals(GPU_THREAD_NAME);
    }

    public boolean isRenderingRelatedThread() {
        return this.isMainThread() || this.isRenderThread() || this.isGpuThread();
    }

    public String toString() {
        return this.getName() + ":" + this.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/cpu/CpuThreadInfo", "getName"));
    }
}

