/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltip;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadTrackModel
implements CpuAnalyzable<CpuThreadTrackModel> {
    @NotNull
    private final StateChartModel<ThreadState> myThreadStateChartModel;
    @NotNull
    private final CaptureDetails.CallChart myCallChartModel;
    @NotNull
    private final CpuCapture myCapture;
    @NotNull
    private final Timeline myTimeline;
    @NotNull
    private final CpuThreadInfo myThreadInfo;
    @NotNull
    private final CpuThreadsTooltip myThreadStateTooltip;
    @NotNull
    private final Function<CaptureNode, CpuCaptureNodeTooltip> myTraceEventTooltipBuilder;
    @NotNull
    private final MultiSelectionModel<CpuAnalyzable<?>> myMultiSelectionModel;
    @Nullable
    private final DataSeries<ThreadState> myThreadStateSeries;
    @NotNull
    private final Function1<Runnable, Unit> myRunInBackground;

    public CpuThreadTrackModel(@NotNull CpuCapture capture, @NotNull CpuThreadInfo threadInfo, @NotNull Timeline timeline, @NotNull MultiSelectionModel<CpuAnalyzable<?>> multiSelectionModel, @NotNull Function1<Runnable, Unit> runModelUpdate) {
        if (capture == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(0);
        }
        if (threadInfo == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(1);
        }
        if (timeline == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(2);
        }
        if (multiSelectionModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(3);
        }
        if (runModelUpdate == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(4);
        }
        this.myThreadStateChartModel = new StateChartModel();
        this.myThreadStateTooltip = new CpuThreadsTooltip(timeline);
        this.myCallChartModel = new CaptureDetails.CallChart(ClockType.GLOBAL, timeline.getViewRange(), Collections.singletonList(capture.getCaptureNode(threadInfo.getId())), capture);
        this.myCapture = capture;
        this.myThreadInfo = threadInfo;
        this.myTimeline = timeline;
        this.myMultiSelectionModel = multiSelectionModel;
        this.myRunInBackground = runModelUpdate;
        if (capture.getSystemTraceData() != null) {
            this.myThreadStateSeries = new LazyDataSeries<ThreadState>(() -> capture.getSystemTraceData().getThreadStatesForThread(threadInfo.getId()));
            this.myThreadStateChartModel.addSeries(new RangedSeries(timeline.getViewRange(), this.myThreadStateSeries));
            this.myThreadStateTooltip.setThread(threadInfo.getName(), this.myThreadStateSeries);
        } else {
            this.myThreadStateSeries = null;
        }
        this.myTraceEventTooltipBuilder = captureNode -> new CpuCaptureNodeTooltip(timeline, (CaptureNode)captureNode);
    }

    @NotNull
    public StateChartModel<ThreadState> getThreadStateChartModel() {
        StateChartModel<ThreadState> stateChartModel = this.myThreadStateChartModel;
        if (stateChartModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(5);
        }
        return stateChartModel;
    }

    @NotNull
    public CaptureDetails.CallChart getCallChartModel() {
        CaptureDetails.CallChart callChart = this.myCallChartModel;
        if (callChart == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(6);
        }
        return callChart;
    }

    @NotNull
    public CpuCapture getCapture() {
        CpuCapture cpuCapture = this.myCapture;
        if (cpuCapture == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(7);
        }
        return cpuCapture;
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CpuThreadTrackModel> getAnalysisModel() {
        CpuAnalysisModel<CpuThreadTrackModel> model = new CpuAnalysisModel<CpuThreadTrackModel>(this.myThreadInfo.getName(), "%d threads");
        Range selectionRange = this.myTimeline.getSelectionRange().isEmpty() ? this.myTimeline.getViewRange() : this.myTimeline.getSelectionRange();
        CpuThreadAnalysisSummaryTabModel summary = new CpuThreadAnalysisSummaryTabModel(this.myCapture.getRange(), selectionRange);
        summary.getDataSeries().add(this);
        model.addTabModel(summary);
        CpuAnalysisChartModel flameChart = new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.FLAME_CHART, selectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode, this.myRunInBackground);
        flameChart.getDataSeries().add(this);
        model.addTabModel(flameChart);
        CpuAnalysisChartModel topDown = new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.TOP_DOWN, selectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode, this.myRunInBackground);
        topDown.getDataSeries().add(this);
        model.addTabModel(topDown);
        CpuAnalysisChartModel bottomUp = new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.BOTTOM_UP, selectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode, this.myRunInBackground);
        bottomUp.getDataSeries().add(this);
        model.addTabModel(bottomUp);
        CpuThreadAnalysisEventsTabModel events = new CpuThreadAnalysisEventsTabModel(this.myCapture.getRange());
        events.getDataSeries().add(this);
        model.addTabModel(events);
        CpuAnalysisModel<CpuThreadTrackModel> cpuAnalysisModel = model;
        if (cpuAnalysisModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(8);
        }
        return cpuAnalysisModel;
    }

    @NotNull
    public CpuThreadsTooltip getThreadStateTooltip() {
        CpuThreadsTooltip cpuThreadsTooltip = this.myThreadStateTooltip;
        if (cpuThreadsTooltip == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(9);
        }
        return cpuThreadsTooltip;
    }

    @NotNull
    public Function<CaptureNode, CpuCaptureNodeTooltip> getTraceEventTooltipBuilder() {
        Function<CaptureNode, CpuCaptureNodeTooltip> function = this.myTraceEventTooltipBuilder;
        if (function == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(10);
        }
        return function;
    }

    @NotNull
    public MultiSelectionModel<CpuAnalyzable<?>> getMultiSelectionModel() {
        MultiSelectionModel<CpuAnalyzable<?>> multiSelectionModel = this.myMultiSelectionModel;
        if (multiSelectionModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(11);
        }
        return multiSelectionModel;
    }

    @NotNull
    public CpuThreadInfo getThreadInfo() {
        CpuThreadInfo cpuThreadInfo = this.myThreadInfo;
        if (cpuThreadInfo == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(12);
        }
        return cpuThreadInfo;
    }

    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.myTimeline;
        if (timeline == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(13);
        }
        return timeline;
    }

    @Nullable
    public DataSeries<ThreadState> getThreadStateSeries() {
        return this.myThreadStateSeries;
    }

    private Collection<CaptureNode> getCaptureNode() {
        assert (this.myCapture.containsThread(this.myThreadInfo.getId()));
        return Collections.singleton(this.myCapture.getCaptureNode(this.myThreadInfo.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiSelectionModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runModelUpdate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadTrackModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadTrackModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStateChartModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallChartModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapture";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStateTooltip";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceEventTooltipBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiSelectionModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

