/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profilers.cpu.ThreadState;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadsTooltip
extends AspectModel<Aspect>
implements TooltipModel {
    @NotNull
    private final Timeline myTimeline;
    @Nullable
    private String myThreadName;
    @Nullable
    private DataSeries<ThreadState> mySeries;
    @Nullable
    private ThreadState myThreadState;
    private long myDurationUs;

    public CpuThreadsTooltip(@NotNull Timeline timeline) {
        if (timeline == null) {
            CpuThreadsTooltip.$$$reportNull$$$0(0);
        }
        this.myTimeline = timeline;
        this.myTimeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateThreadState);
    }

    public void dispose() {
        this.myTimeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private void updateThreadState() {
        this.myThreadState = null;
        this.myDurationUs = 0L;
        if (this.mySeries == null) {
            this.changed(Aspect.THREAD_STATE);
            return;
        }
        Range tooltipRange = this.myTimeline.getTooltipRange();
        List series = this.mySeries.getDataForRange(this.myTimeline.getViewRange());
        int threadStateIndex = Collections.binarySearch(series, new SeriesData((long)tooltipRange.getMin(), null), Comparator.comparingDouble(seriesData -> seriesData.x));
        if (threadStateIndex < 0) {
            threadStateIndex = -threadStateIndex - 2;
        }
        if (threadStateIndex >= 0) {
            SeriesData currentState = (SeriesData)series.get(threadStateIndex);
            this.myThreadState = (ThreadState)((Object)currentState.value);
            if (threadStateIndex < series.size() - 1) {
                this.myDurationUs = ((SeriesData)series.get((int)(threadStateIndex + 1))).x - currentState.x;
            }
        }
        this.changed(Aspect.THREAD_STATE);
    }

    public void setThread(@Nullable String threadName, @Nullable DataSeries<ThreadState> stateSeries) {
        this.myThreadName = threadName;
        this.mySeries = stateSeries;
        this.updateThreadState();
    }

    @Nullable
    public String getThreadName() {
        return this.myThreadName;
    }

    @Nullable
    ThreadState getThreadState() {
        return this.myThreadState;
    }

    public long getDurationUs() {
        return this.myDurationUs;
    }

    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.myTimeline;
        if (timeline == null) {
            CpuThreadsTooltip.$$$reportNull$$$0(1);
        }
        return timeline;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadsTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsTooltip";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum Aspect {
        THREAD_STATE;

    }
}

