/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;

public class CpuThreadsTooltipView
extends TooltipView {
    @NotNull
    private final CpuThreadsTooltip myTooltip;
    @NotNull
    private final JPanel myContent;
    @NotNull
    private final JLabel myLabel;
    @NotNull
    private final JLabel myState;
    @NotNull
    private final JLabel myDuration;
    @NotNull
    private final JPanel myUnavailableDetails;

    protected CpuThreadsTooltipView(@NotNull JComponent parent, @NotNull CpuThreadsTooltip tooltip) {
        if (parent == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltip == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(1);
        }
        super(tooltip.getTimeline());
        this.myTooltip = tooltip;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUIScale.scale((int)8)));
        this.myLabel = CpuThreadsTooltipView.createTooltipLabel();
        this.myState = CpuThreadsTooltipView.createTooltipLabel();
        this.myDuration = CpuThreadsTooltipView.createTooltipLabel();
        this.myUnavailableDetails = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUIScale.scale((int)1)));
        tooltip.addDependency((AspectObserver)this).onChange((Enum)CpuThreadsTooltip.Aspect.THREAD_STATE, this::stateChanged);
    }

    public void dispose() {
        super.dispose();
        this.myTooltip.removeDependencies((AspectObserver)this);
    }

    private static void addRow(JPanel parent, JComponent c) {
        int nextRow = parent.getComponentCount();
        parent.add((Component)c, new TabularLayout.Constraint(nextRow, 0));
    }

    private void stateChanged() {
        Range range = this.getTimeline().getTooltipRange();
        this.myContent.removeAll();
        if (range.isEmpty()) {
            CpuThreadsTooltipView.addRow(this.myContent, this.myUnavailableDetails);
            return;
        }
        String title = this.myTooltip.getThreadName() != null ? this.myTooltip.getThreadName() : "CPU";
        this.myLabel.setText(String.format("Thread: %s", title));
        CpuThreadsTooltipView.addRow(this.myContent, this.myLabel);
        if (this.myTooltip.getThreadState() != null) {
            this.myState.setText(this.myTooltip.getThreadState().getDisplayName());
            CpuThreadsTooltipView.addRow(this.myContent, this.myState);
            if (this.myTooltip.getDurationUs() > 0L) {
                this.myDuration.setText(TimeFormatter.getSingleUnitDurationString((long)this.myTooltip.getDurationUs()));
                CpuThreadsTooltipView.addRow(this.myContent, this.myDuration);
            }
            if (!this.myTooltip.getThreadState().isCaptured()) {
                CpuThreadsTooltipView.addRow(this.myContent, this.myUnavailableDetails);
            }
        }
    }

    @NotNull
    protected JComponent createTooltip() {
        JSeparator separator = new JSeparator(0);
        separator.setMinimumSize(separator.getPreferredSize());
        CpuThreadsTooltipView.addRow(this.myUnavailableDetails, separator);
        JLabel unavailableLabel = new JLabel("Details Unavailable");
        unavailableLabel.setFont(TOOLTIP_BODY_FONT);
        unavailableLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        CpuThreadsTooltipView.addRow(this.myUnavailableDetails, unavailableLabel);
        CpuThreadsTooltipView.addRow(this.myContent, this.myUnavailableDetails);
        JPanel jPanel = this.myContent;
        if (jPanel == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadsTooltipView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsTooltipView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

