/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.MergeCaptureDataSeries;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class CpuUsage
extends LineChartModel {
    @NotNull
    private final Range myCpuRange;
    @NotNull
    private final RangedContinuousSeries myCpuSeries;

    public CpuUsage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuUsage.$$$reportNull$$$0(0);
        }
        this(profilers, profilers.getTimeline().getViewRange(), profilers.getTimeline().getDataRange(), null);
    }

    public CpuUsage(@NotNull StudioProfilers profilers, @NotNull Range viewRange, @NotNull Range dataRange, @Nullable CpuCapture cpuCapture) {
        if (profilers == null) {
            CpuUsage.$$$reportNull$$$0(1);
        }
        if (viewRange == null) {
            CpuUsage.$$$reportNull$$$0(2);
        }
        if (dataRange == null) {
            CpuUsage.$$$reportNull$$$0(3);
        }
        this.myCpuRange = new Range(0.0, 100.0);
        DataSeries<Long> series = CpuUsage.buildDataSeries(profilers.getClient().getTransportClient(), profilers.getSession(), cpuCapture);
        this.myCpuSeries = new RangedContinuousSeries(this.getCpuSeriesLabel(), viewRange, this.myCpuRange, series, dataRange);
        this.add(this.myCpuSeries);
    }

    @NotNull
    public Range getCpuRange() {
        Range range = this.myCpuRange;
        if (range == null) {
            CpuUsage.$$$reportNull$$$0(4);
        }
        return range;
    }

    @NotNull
    public RangedContinuousSeries getCpuSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myCpuSeries;
        if (rangedContinuousSeries == null) {
            CpuUsage.$$$reportNull$$$0(5);
        }
        return rangedContinuousSeries;
    }

    protected String getCpuSeriesLabel() {
        return "";
    }

    protected static List<SeriesData<Long>> extractData(List<Common.Event> dataList, boolean isOtherProcess) {
        return IntStream.range(0, dataList.size() - 1).mapToObj(index -> CpuUsage.getCpuUsageData(((Common.Event)dataList.get(index)).getCpuUsage(), ((Common.Event)dataList.get(index + 1)).getCpuUsage(), isOtherProcess)).collect(Collectors.toList());
    }

    protected static SeriesData<Long> getCpuUsageData(Cpu.CpuUsageData prevData, Cpu.CpuUsageData data, boolean isOtherProcess) {
        long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
        long elapsed = data.getElapsedTimeInMillisec() - prevData.getElapsedTimeInMillisec();
        double app = 100.0 * (double)(data.getAppCpuTimeInMillisec() - prevData.getAppCpuTimeInMillisec()) / (double)elapsed;
        double system = 100.0 * (double)(data.getSystemCpuTimeInMillisec() - prevData.getSystemCpuTimeInMillisec()) / (double)elapsed;
        system = Math.max(0.0, Math.min(system, 100.0));
        app = Math.max(0.0, Math.min(app, system));
        return new SeriesData(dataTimestamp, (Object)((long)(isOtherProcess ? system - app : app)));
    }

    @VisibleForTesting
    public static DataSeries<Long> buildDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, @NotNull Common.Session session, @Nullable CpuCapture cpuCapture) {
        if (client == null) {
            CpuUsage.$$$reportNull$$$0(6);
        }
        if (session == null) {
            CpuUsage.$$$reportNull$$$0(7);
        }
        Object series = new UnifiedEventDataSeries<Long>(client, session.getStreamId(), session.getPid(), Common.Event.Kind.CPU_USAGE, session.getPid(), events -> CpuUsage.extractData(events, false));
        if (cpuCapture != null && cpuCapture.getSystemTraceData() != null) {
            series = new MergeCaptureDataSeries<Long>(cpuCapture, (DataSeries<Long>)series, new LazyDataSeries(() -> cpuCapture.getSystemTraceData().getCpuUtilizationSeries()));
        }
        return series;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuUsage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildDataSeries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

