/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import org.jetbrains.annotations.NotNull;

public enum ProfilingTechnology {
    ART_SAMPLED("Java/Kotlin Method Sample Recording (legacy)", "Samples Java/Kotlin code using Android Runtime."),
    ART_INSTRUMENTED("Java/Kotlin Method Trace Recording", "Instruments Java/Kotlin code using Android Runtime, tracking every method call (this incurs high overhead making timing information inaccurate)."),
    ART_UNSPECIFIED("Java/Kotlin Method Recording", "Profiles method calls using Android Runtime."),
    SIMPLEPERF("Callstack Sample Recording", "Samples Java/Kotlin and native code using simpleperf.", "Available for Android 8.0 (API level 26) and higher."),
    SYSTEM_TRACE("System Trace Recording", "Traces Java/Kotlin and native code at the Android platform level.", "Available for Android 7.0 (API level 24) and higher.");

    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    @NotNull
    private final String myExtraDescription;

    private ProfilingTechnology(@NotNull String name, String description, String extraDescription) {
        if (name == null) {
            ProfilingTechnology.$$$reportNull$$$0(0);
        }
        if (description == null) {
            ProfilingTechnology.$$$reportNull$$$0(1);
        }
        if (extraDescription == null) {
            ProfilingTechnology.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myDescription = description;
        this.myExtraDescription = extraDescription;
    }

    private ProfilingTechnology(String name, String description) {
        if (name == null) {
            ProfilingTechnology.$$$reportNull$$$0(3);
        }
        if (description == null) {
            ProfilingTechnology.$$$reportNull$$$0(4);
        }
        this(name, description, "");
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getLongDescription() {
        String string = String.format("<html>%s %s</html>", this.myDescription, this.myExtraDescription);
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public ProfilingConfiguration.TraceType getType() {
        switch (this) {
            case ART_SAMPLED: {
                ProfilingConfiguration.TraceType traceType = ProfilingConfiguration.TraceType.ART;
                if (traceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(8);
                }
                return traceType;
            }
            case ART_INSTRUMENTED: {
                ProfilingConfiguration.TraceType traceType = ProfilingConfiguration.TraceType.ART;
                if (traceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(9);
                }
                return traceType;
            }
            case ART_UNSPECIFIED: {
                ProfilingConfiguration.TraceType traceType = ProfilingConfiguration.TraceType.ART;
                if (traceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(10);
                }
                return traceType;
            }
            case SIMPLEPERF: {
                ProfilingConfiguration.TraceType traceType = ProfilingConfiguration.TraceType.SIMPLEPERF;
                if (traceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(11);
                }
                return traceType;
            }
            case SYSTEM_TRACE: {
                ProfilingConfiguration.TraceType traceType = ProfilingConfiguration.TraceType.ATRACE;
                if (traceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(12);
                }
                return traceType;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public Trace.TraceMode getMode() {
        switch (this) {
            case ART_SAMPLED: {
                Trace.TraceMode traceMode = Trace.TraceMode.SAMPLED;
                if (traceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(13);
                }
                return traceMode;
            }
            case ART_INSTRUMENTED: {
                Trace.TraceMode traceMode = Trace.TraceMode.INSTRUMENTED;
                if (traceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(14);
                }
                return traceMode;
            }
            case ART_UNSPECIFIED: {
                Trace.TraceMode traceMode = Trace.TraceMode.UNSPECIFIED_MODE;
                if (traceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(15);
                }
                return traceMode;
            }
            case SIMPLEPERF: {
                Trace.TraceMode traceMode = Trace.TraceMode.SAMPLED;
                if (traceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(16);
                }
                return traceMode;
            }
            case SYSTEM_TRACE: {
                Trace.TraceMode traceMode = Trace.TraceMode.INSTRUMENTED;
                if (traceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(17);
                }
                return traceMode;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public static ProfilingTechnology fromTraceConfiguration(@NotNull Trace.TraceConfiguration config) {
        if (config == null) {
            ProfilingTechnology.$$$reportNull$$$0(18);
        }
        switch (config.getUnionCase()) {
            case ART_OPTIONS: {
                if (config.getArtOptions().getTraceMode() == Trace.TraceMode.SAMPLED) {
                    ProfilingTechnology profilingTechnology = ART_SAMPLED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(19);
                    }
                    return profilingTechnology;
                }
                if (config.getArtOptions().getTraceMode() == Trace.TraceMode.INSTRUMENTED) {
                    ProfilingTechnology profilingTechnology = ART_INSTRUMENTED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(20);
                    }
                    return profilingTechnology;
                }
                ProfilingTechnology profilingTechnology = ART_UNSPECIFIED;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(21);
                }
                return profilingTechnology;
            }
            case SIMPLEPERF_OPTIONS: {
                ProfilingTechnology profilingTechnology = SIMPLEPERF;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(22);
                }
                return profilingTechnology;
            }
            case ATRACE_OPTIONS: 
            case PERFETTO_OPTIONS: {
                ProfilingTechnology profilingTechnology = SYSTEM_TRACE;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(23);
                }
                return profilingTechnology;
            }
        }
        throw new IllegalStateException("Error while trying to get the name of an unknown profiling configuration");
    }

    @NotNull
    public static ProfilingTechnology fromConfig(@NotNull ProfilingConfiguration config) {
        if (config == null) {
            ProfilingTechnology.$$$reportNull$$$0(24);
        }
        switch (config.getTraceType()) {
            case ART: {
                if (config instanceof ArtSampledConfiguration) {
                    ProfilingTechnology profilingTechnology = ART_SAMPLED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(25);
                    }
                    return profilingTechnology;
                }
                if (config instanceof ArtInstrumentedConfiguration) {
                    ProfilingTechnology profilingTechnology = ART_INSTRUMENTED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(26);
                    }
                    return profilingTechnology;
                }
                ProfilingTechnology profilingTechnology = ART_UNSPECIFIED;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(27);
                }
                return profilingTechnology;
            }
            case SIMPLEPERF: {
                ProfilingTechnology profilingTechnology = SIMPLEPERF;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(28);
                }
                return profilingTechnology;
            }
            case ATRACE: 
            case PERFETTO: {
                ProfilingTechnology profilingTechnology = SYSTEM_TRACE;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(29);
                }
                return profilingTechnology;
            }
        }
        throw new IllegalStateException("Error while trying to get the name of an unknown profiling configuration");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraDescription";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/ProfilingTechnology";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/ProfilingTechnology";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescription";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTraceConfiguration";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "fromConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fromTraceConfiguration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fromConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }
}

