/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.EventLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ChartTooltipViewBase;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CaptureNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class CpuTraceEventTooltipView
extends ChartTooltipViewBase<CaptureNode> {
    @NotNull
    private final TraceEventTooltipLegends myLegends;
    @NotNull
    private final Color myRunningColor;
    @NotNull
    private final Color myIdleColor;

    protected CpuTraceEventTooltipView(@NotNull HTreeChart<CaptureNode> chart2, @NotNull JComponent tooltipRoot, @NotNull Color runningColor, @NotNull Color idleColor) {
        if (chart2 == null) {
            CpuTraceEventTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltipRoot == null) {
            CpuTraceEventTooltipView.$$$reportNull$$$0(1);
        }
        if (runningColor == null) {
            CpuTraceEventTooltipView.$$$reportNull$$$0(2);
        }
        if (idleColor == null) {
            CpuTraceEventTooltipView.$$$reportNull$$$0(3);
        }
        super(chart2, tooltipRoot);
        this.myLegends = new TraceEventTooltipLegends();
        this.myRunningColor = runningColor;
        this.myIdleColor = idleColor;
    }

    @Override
    public void showTooltip(@NotNull CaptureNode node) {
        if (node == null) {
            CpuTraceEventTooltipView.$$$reportNull$$$0(4);
        }
        long totalDuration = node.getDuration();
        long threadDuration = Math.min(totalDuration, Math.max(0L, node.getEndThread() - node.getStartThread()));
        long idleDuration = totalDuration - threadDuration;
        this.getTooltipContainer().removeAll();
        JLabel nameLabel = new JLabel(node.getData().getFullName());
        nameLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.myLegends.getRunningDurationLegend().setPickData((DurationData)new DefaultDurationData(threadDuration));
        this.myLegends.getIdleDurationLegend().setPickData((DurationData)new DefaultDurationData(idleDuration));
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)this.myLegends).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        legend.setForeground(ProfilerColors.TOOLTIP_TEXT);
        legend.configure(this.myLegends.getRunningDurationLegend(), new LegendConfig(LegendConfig.IconType.BOX, this.myRunningColor));
        legend.configure(this.myLegends.getIdleDurationLegend(), new LegendConfig(LegendConfig.IconType.BOX, this.myIdleColor));
        JLabel totalLabel = new JLabel(String.format("Total: %s", TimeFormatter.getSingleUnitDurationString((long)totalDuration)));
        this.getTooltipContainer().add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        this.getTooltipContainer().add((Component)legend, new TabularLayout.Constraint(1, 0));
        this.getTooltipContainer().add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(2, 0));
        this.getTooltipContainer().add((Component)totalLabel, new TabularLayout.Constraint(3, 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningColor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idleColor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuTraceEventTooltipView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TraceEventTooltipLegends
    extends LegendComponentModel {
        @NotNull
        private final EventLegend<DefaultDurationData> myRunningDurationLegend = new EventLegend("Running", e -> TimeFormatter.getSingleUnitDurationString((long)e.getDurationUs()));
        @NotNull
        private final EventLegend<DefaultDurationData> myIdleDurationLegend = new EventLegend("Idle", e -> TimeFormatter.getSingleUnitDurationString((long)e.getDurationUs()));

        TraceEventTooltipLegends() {
            this.add((Legend)this.myRunningDurationLegend);
            this.add((Legend)this.myIdleDurationLegend);
        }

        @NotNull
        EventLegend<DefaultDurationData> getRunningDurationLegend() {
            EventLegend<DefaultDurationData> eventLegend = this.myRunningDurationLegend;
            if (eventLegend == null) {
                TraceEventTooltipLegends.$$$reportNull$$$0(0);
            }
            return eventLegend;
        }

        @NotNull
        EventLegend<DefaultDurationData> getIdleDurationLegend() {
            EventLegend<DefaultDurationData> eventLegend = this.myIdleDurationLegend;
            if (eventLegend == null) {
                TraceEventTooltipLegends.$$$reportNull$$$0(1);
            }
            return eventLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/cpu/capturedetails/CpuTraceEventTooltipView$TraceEventTooltipLegends";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunningDurationLegend";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdleDurationLegend";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

