/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.config;

import com.android.tools.adtui.model.options.OptionsProperty;
import com.android.tools.adtui.model.options.OptionsProvider;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.AtraceConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilingConfiguration
implements OptionsProvider {
    public static final String DEFAULT_CONFIGURATION_NAME = "Unnamed";
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int SYSTEM_TRACE_BUFFER_SIZE_MB = 4;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    public static final String TRACE_CONFIG_GROUP = "Trace config";
    @NotNull
    private String myName;

    protected ProfilingConfiguration(@NotNull String name) {
        if (name == null) {
            ProfilingConfiguration.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NotNull
    public abstract TraceType getTraceType();

    @OptionsProperty(name="Configuration name: ", group="Trace config", order=99)
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProfilingConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @OptionsProperty
    public void setName(@NotNull String name) {
        if (name == null) {
            ProfilingConfiguration.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    public abstract int getRequiredDeviceLevel();

    public boolean isDeviceLevelSupported(int deviceLevel) {
        return deviceLevel >= this.getRequiredDeviceLevel();
    }

    @NotNull
    public static ProfilingConfiguration fromProto(@NotNull Trace.TraceConfiguration proto) {
        if (proto == null) {
            ProfilingConfiguration.$$$reportNull$$$0(3);
        }
        switch (proto.getUnionCase()) {
            case ART_OPTIONS: {
                if (proto.getArtOptions().getTraceMode() == Trace.TraceMode.SAMPLED) {
                    ArtSampledConfiguration artSampled = new ArtSampledConfiguration("");
                    artSampled.setProfilingSamplingIntervalUs(proto.getArtOptions().getSamplingIntervalUs());
                    artSampled.setProfilingBufferSizeInMb(proto.getArtOptions().getBufferSizeInMb());
                    ArtSampledConfiguration artSampledConfiguration = artSampled;
                    if (artSampledConfiguration == null) {
                        ProfilingConfiguration.$$$reportNull$$$0(4);
                    }
                    return artSampledConfiguration;
                }
                ArtInstrumentedConfiguration artInstrumented = new ArtInstrumentedConfiguration("");
                artInstrumented.setProfilingBufferSizeInMb(proto.getArtOptions().getBufferSizeInMb());
                ArtInstrumentedConfiguration artInstrumentedConfiguration = artInstrumented;
                if (artInstrumentedConfiguration == null) {
                    ProfilingConfiguration.$$$reportNull$$$0(5);
                }
                return artInstrumentedConfiguration;
            }
            case PERFETTO_OPTIONS: {
                PerfettoConfiguration perfetto;
                PerfettoConfiguration perfettoConfiguration = perfetto = new PerfettoConfiguration("");
                if (perfettoConfiguration == null) {
                    ProfilingConfiguration.$$$reportNull$$$0(6);
                }
                return perfettoConfiguration;
            }
            case ATRACE_OPTIONS: {
                AtraceConfiguration atrace;
                AtraceConfiguration atraceConfiguration = atrace = new AtraceConfiguration("");
                if (atraceConfiguration == null) {
                    ProfilingConfiguration.$$$reportNull$$$0(7);
                }
                return atraceConfiguration;
            }
            case SIMPLEPERF_OPTIONS: {
                SimpleperfConfiguration simpleperf = new SimpleperfConfiguration("");
                simpleperf.setProfilingSamplingIntervalUs(proto.getSimpleperfOptions().getSamplingIntervalUs());
                SimpleperfConfiguration simpleperfConfiguration = simpleperf;
                if (simpleperfConfiguration == null) {
                    ProfilingConfiguration.$$$reportNull$$$0(8);
                }
                return simpleperfConfiguration;
            }
        }
        return new UnspecifiedConfiguration(DEFAULT_CONFIGURATION_NAME);
    }

    protected abstract GeneratedMessageV3 getOptions();

    public abstract void addOptions(Trace.TraceConfiguration.Builder var1, Map<AdditionalOptions, ? extends Object> var2);

    public boolean equals(Object obj) {
        if (!(obj instanceof ProfilingConfiguration)) {
            return false;
        }
        ProfilingConfiguration incoming = (ProfilingConfiguration)obj;
        return incoming.getOptions().equals((Object)this.getOptions());
    }

    public int hashCode() {
        return this.getOptions().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/config/ProfilingConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/config/ProfilingConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromProto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromProto";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static enum TraceType {
        ART("Art"),
        ATRACE("Atrace"),
        SIMPLEPERF("Simpleperf"),
        PERFETTO("Perfetto"),
        UNSPECIFIED("Unspecified");

        @NotNull
        private final String myDisplayName;

        @NotNull
        public static TraceType from(@NotNull Trace.TraceConfiguration config) {
            if (config == null) {
                TraceType.$$$reportNull$$$0(0);
            }
            if (config.hasArtOptions()) {
                TraceType traceType = ART;
                if (traceType == null) {
                    TraceType.$$$reportNull$$$0(1);
                }
                return traceType;
            }
            if (config.hasAtraceOptions()) {
                TraceType traceType = ATRACE;
                if (traceType == null) {
                    TraceType.$$$reportNull$$$0(2);
                }
                return traceType;
            }
            if (config.hasSimpleperfOptions()) {
                TraceType traceType = SIMPLEPERF;
                if (traceType == null) {
                    TraceType.$$$reportNull$$$0(3);
                }
                return traceType;
            }
            if (config.hasPerfettoOptions()) {
                TraceType traceType = PERFETTO;
                if (traceType == null) {
                    TraceType.$$$reportNull$$$0(4);
                }
                return traceType;
            }
            TraceType traceType = UNSPECIFIED;
            if (traceType == null) {
                TraceType.$$$reportNull$$$0(5);
            }
            return traceType;
        }

        private TraceType(String displayName) {
            if (displayName == null) {
                TraceType.$$$reportNull$$$0(6);
            }
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                TraceType.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/config/ProfilingConfiguration$TraceType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/config/ProfilingConfiguration$TraceType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static enum AdditionalOptions {
        SYMBOL_DIRS,
        APP_PKG_NAME;

    }
}

