/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.nodemodel;

import com.android.tools.profilers.cpu.nodemodel.NativeNodeModel;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CppFunctionModel
extends NativeNodeModel {
    private static final Pattern PARAMETERS_SEPARATOR = Pattern.compile(", ");
    @NotNull
    private final String myClassOrNamespace;
    @NotNull
    private final List<String> myParameters;
    private final boolean myIsUserCode;
    private final String myFileName;
    private final long myVAddress;
    private String myFullName;
    private String myId;
    private final String myTag;

    private CppFunctionModel(Builder builder) {
        this.myName = builder.myName;
        this.myClassOrNamespace = builder.myClassOrNamespace;
        this.myParameters = CppFunctionModel.buildParameters(builder.myParameters);
        this.myIsUserCode = builder.myIsUserCode;
        this.myFileName = builder.myFileName;
        this.myVAddress = builder.myVAddress;
        this.myTag = builder.myTag;
    }

    @NotNull
    public String getClassOrNamespace() {
        String string = this.myClassOrNamespace;
        if (string == null) {
            CppFunctionModel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public List<String> getParameters() {
        List<String> list = this.myParameters;
        if (list == null) {
            CppFunctionModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isUserCode() {
        return this.myIsUserCode;
    }

    public String getFileName() {
        return this.myFileName;
    }

    @Override
    public String getTag() {
        return this.myTag;
    }

    public long getVAddress() {
        return this.myVAddress;
    }

    @Override
    @NotNull
    public String getFullName() {
        if (this.myFullName == null) {
            String separator = StringUtil.isEmpty((String)this.myClassOrNamespace) ? "" : "::";
            this.myFullName = String.format("%s%s%s", this.myClassOrNamespace, separator, this.myName);
        }
        String string = this.myFullName;
        if (string == null) {
            CppFunctionModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        if (this.myId == null) {
            this.myId = String.format("%s%s", this.getFullName(), this.myParameters.toString());
        }
        String string = this.myId;
        if (string == null) {
            CppFunctionModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static List<String> buildParameters(@NotNull String parameters) {
        if (parameters == null) {
            CppFunctionModel.$$$reportNull$$$0(4);
        }
        ArrayList<String> parsedParameters = new ArrayList<String>();
        if (parameters.isEmpty()) {
            return parsedParameters;
        }
        Collections.addAll(parsedParameters, PARAMETERS_SEPARATOR.split(parameters));
        return parsedParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/nodemodel/CppFunctionModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassOrNamespace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/nodemodel/CppFunctionModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }

    public static class Builder {
        @NotNull
        private final String myName;
        @NotNull
        private String myClassOrNamespace;
        private boolean myIsUserCode;
        @NotNull
        private String myParameters;
        private String myFileName;
        private long myVAddress;
        private String myTag;

        public Builder(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myClassOrNamespace = "";
            this.myParameters = "";
        }

        public Builder setClassOrNamespace(@NotNull String classOrNamespace) {
            if (classOrNamespace == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myClassOrNamespace = classOrNamespace;
            return this;
        }

        public Builder setParameters(@NotNull String parameters) {
            if (parameters == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myParameters = parameters;
            return this;
        }

        public Builder setIsUserCode(boolean isUserCode) {
            this.myIsUserCode = isUserCode;
            return this;
        }

        public Builder setFileName(String fileName) {
            this.myFileName = fileName;
            return this;
        }

        public Builder setTag(String tag) {
            this.myTag = tag;
            return this;
        }

        public Builder setVAddress(long vAddress) {
            this.myVAddress = vAddress;
            return this;
        }

        public CppFunctionModel build() {
            return new CppFunctionModel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classOrNamespace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/cpu/nodemodel/CppFunctionModel$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setClassOrNamespace";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

