/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.MainProcessSelector;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AtraceProducer;
import com.android.tools.profilers.cpu.systemtrace.PerfettoProducer;
import com.android.tools.profilers.cpu.systemtrace.ProcessListSorter;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCaptureBuilder;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.TrebuchetBufferProducer;
import com.android.tools.profilers.cpu.systemtrace.TrebuchetModelAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.Model;
import trebuchet.task.ImportTask;
import trebuchet.util.PrintlnImportFeedback;

public class AtraceParser
implements TraceParser {
    @NotNull
    private final MainProcessSelector processSelector;
    @NotNull
    private final ProfilingConfiguration.TraceType myCpuTraceType;

    @VisibleForTesting
    public AtraceParser() {
        this(new MainProcessSelector("", 0, null));
    }

    public AtraceParser(@NotNull MainProcessSelector processSelector) {
        if (processSelector == null) {
            AtraceParser.$$$reportNull$$$0(0);
        }
        this(ProfilingConfiguration.TraceType.ATRACE, processSelector);
    }

    public AtraceParser(@NotNull ProfilingConfiguration.TraceType type, @NotNull MainProcessSelector processSelector) {
        if (type == null) {
            AtraceParser.$$$reportNull$$$0(1);
        }
        if (processSelector == null) {
            AtraceParser.$$$reportNull$$$0(2);
        }
        this.processSelector = processSelector;
        Preconditions.checkArgument((type == ProfilingConfiguration.TraceType.ATRACE || type == ProfilingConfiguration.TraceType.PERFETTO ? 1 : 0) != 0, (Object)"type must be ATRACE or PERFETTO.");
        this.myCpuTraceType = type;
    }

    @Override
    public CpuCapture parse(@NotNull File file, long traceId) throws IOException {
        SystemTraceModelAdapter model;
        if (file == null) {
            AtraceParser.$$$reportNull$$$0(3);
        }
        if ((model = this.parseToModel(file)).getProcesses().isEmpty()) {
            throw new IllegalStateException("Invalid trace without any process information.");
        }
        ProcessListSorter sorter = new ProcessListSorter(this.processSelector.getNameHint());
        Integer selectedProcess = this.processSelector.apply(sorter.sort(model.getProcesses()));
        if (selectedProcess == null) {
            throw new IllegalStateException("It was not possible to select a process for this trace.");
        }
        SystemTraceCpuCaptureBuilder builder = new SystemTraceCpuCaptureBuilder(model);
        return builder.build(traceId, selectedProcess, new Range((double)model.getCaptureStartTimestampUs(), (double)model.getCaptureEndTimestampUs()));
    }

    private SystemTraceModelAdapter parseToModel(@NotNull File file) throws IOException {
        TrebuchetBufferProducer producer;
        if (file == null) {
            AtraceParser.$$$reportNull$$$0(4);
        }
        if (this.myCpuTraceType == ProfilingConfiguration.TraceType.ATRACE) {
            producer = new AtraceProducer();
        } else if (this.myCpuTraceType == ProfilingConfiguration.TraceType.PERFETTO) {
            producer = new PerfettoProducer();
        } else {
            throw new IllegalStateException("Trying to parse something that is not ATRACE nor PERFETTO.");
        }
        if (!producer.parseFile(file)) {
            throw new IOException("Failed to parse file: " + file.getAbsolutePath());
        }
        ImportTask task = new ImportTask(new PrintlnImportFeedback());
        Model trebuchetModel = task.importBuffer(producer);
        return new TrebuchetModelAdapter(trebuchetModel, this.myCpuTraceType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processSelector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/systemtrace/AtraceParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseToModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

