/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profilers.cpu.systemtrace.TrebuchetBufferProducer;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Queue;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.io.DataSlice;

public class AtraceProducer
implements TrebuchetBufferProducer {
    private static final int BUFFER_SIZE_BYTES = 2048;
    private byte[] myOutputBuffer = new byte[2048];
    private byte[] myInputBuffer = new byte[2048];
    private int myInputBufferOffset = 2048;
    private boolean myIsFinished = false;
    private Queue<String> myLineQueue = new LinkedList<String>();
    private String myLastPartialLine = "";
    private InputStream myInputStream;
    private Inflater myInflater;
    public static final ByteString HEADER = ByteString.copyFrom((String)"TRACE:\n", (Charset)StandardCharsets.UTF_8);

    private static Logger getLogger() {
        return Logger.getInstance(AtraceProducer.class);
    }

    @Override
    public boolean parseFile(File file) {
        try {
            this.myInputStream = new FileInputStream(file);
            this.myInflater = new Inflater();
            this.fillInputBuffer();
            this.verifyHeader();
            this.myLineQueue.add("# Initial Data Required by Importer");
            return true;
        }
        catch (IOException ex) {
            AtraceProducer.getLogger().error((Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyFileHasAtraceHeader(@NotNull File trace) {
        if (trace == null) {
            AtraceProducer.$$$reportNull$$$0(0);
        }
        try (FileInputStream input = new FileInputStream(trace);){
            byte[] buffer = new byte[HEADER.size()];
            int bytesRead = input.read(buffer, 0, HEADER.size());
            if (bytesRead != HEADER.size()) {
                AtraceProducer.getLogger().warn("Some bytes of the trace file header could not be read.");
                boolean bl = false;
                return bl;
            }
            ByteString fileHeader = ByteString.copyFrom((byte[])buffer);
            boolean bl = HEADER.toStringUtf8().equals(fileHeader.toStringUtf8());
            return bl;
        }
        catch (IOException e) {
            AtraceProducer.getLogger().warn("There was an error trying to read the trace file.");
            return false;
        }
    }

    private void verifyHeader() {
        for (int i = 0; i < HEADER.size(); ++i) {
            assert (HEADER.byteAt(i) == this.myInputBuffer[this.myInputBufferOffset]);
            ++this.myInputBufferOffset;
        }
    }

    private int fillInputBuffer() throws IOException {
        this.shift(this.myInputBuffer, this.myInputBufferOffset, 0, this.myInputBuffer.length - this.myInputBufferOffset);
        this.myInputBufferOffset = this.myInputBuffer.length - this.myInputBufferOffset;
        return this.myInputStream.read(this.myInputBuffer, this.myInputBufferOffset, this.myInputBuffer.length - this.myInputBufferOffset);
    }

    private void fill() throws IOException {
        int readAmount = this.fillInputBuffer();
        this.myInflater.setInput(this.myInputBuffer, 0, readAmount + this.myInputBufferOffset);
        this.myInputBufferOffset = 0;
    }

    private void shift(byte[] data, int srcOffset, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            data[destOffset + i] = data[srcOffset + i];
        }
    }

    public String getNextLine() throws IOException, DataFormatException {
        if (this.myIsFinished && this.myLineQueue.isEmpty()) {
            return null;
        }
        while (this.myLineQueue.isEmpty()) {
            if (this.myInflater.finished()) {
                if (this.myInputStream.available() == 0) {
                    this.myIsFinished = true;
                    this.myInputStream.close();
                    this.myLineQueue.add(this.myLastPartialLine);
                    this.myLastPartialLine = "";
                    break;
                }
                if (this.myInputBufferOffset + HEADER.size() >= this.myInputBuffer.length) {
                    this.fillInputBuffer();
                }
                this.verifyHeader();
                this.myInflater = new Inflater();
            }
            if (this.myInflater.needsInput()) {
                this.fill();
            }
            int inputBufferTotal = this.myInflater.getTotalIn();
            int bytesInOutputBuffer = this.myInflater.inflate(this.myOutputBuffer, 0, this.myOutputBuffer.length);
            inputBufferTotal = this.myInflater.getTotalIn() - inputBufferTotal;
            this.myInputBufferOffset += inputBufferTotal;
            this.myLastPartialLine = this.myLastPartialLine + new String(this.myOutputBuffer, 0, bytesInOutputBuffer);
            String[] lines = this.myLastPartialLine.split("\n", -1);
            for (int i = 0; i < lines.length - 1; ++i) {
                this.myLineQueue.add(lines[i].trim());
            }
            this.myLastPartialLine = this.myLastPartialLine.substring(this.myLastPartialLine.lastIndexOf(10) + 1);
        }
        return this.myLineQueue.remove();
    }

    @Override
    public void close() {
        try {
            this.myInflater.end();
            this.myInputStream.close();
        }
        catch (IOException ex) {
            AtraceProducer.getLogger().warn((Throwable)ex);
        }
    }

    @Override
    @Nullable
    public DataSlice next() {
        try {
            String line = this.getNextLine();
            if (line != null) {
                byte[] data = String.format("%s\n", line.substring(0, Math.min(1022, line.length()))).getBytes();
                return new DataSlice(data, 0, data.length);
            }
        }
        catch (IOException | DataFormatException ex) {
            AtraceProducer.getLogger().error((Throwable)ex);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/android/tools/profilers/cpu/systemtrace/AtraceProducer", "verifyFileHasAtraceHeader"));
    }
}

