/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class SliceStream {
    @NotNull
    private final List<TraceEventModel> mySlices;
    private Pattern myPattern;
    private Range myRange;

    public SliceStream(@NotNull List<TraceEventModel> slices) {
        if (slices == null) {
            SliceStream.$$$reportNull$$$0(0);
        }
        this.myPattern = Pattern.compile(".*");
        this.myRange = new Range(Double.MIN_VALUE, Double.MAX_VALUE);
        this.mySlices = slices;
    }

    public SliceStream matchPattern(@NotNull Pattern pattern) {
        if (pattern == null) {
            SliceStream.$$$reportNull$$$0(1);
        }
        this.myPattern = pattern;
        return this;
    }

    public SliceStream matchName(@NotNull String name) {
        if (name == null) {
            SliceStream.$$$reportNull$$$0(2);
        }
        return this.matchPattern(Pattern.compile("^" + Pattern.quote(name)));
    }

    public SliceStream overlapsRange(Range range) {
        this.myRange = range;
        return this;
    }

    public void enumerate(@NotNull Function<TraceEventModel, EnumerationResult> action) {
        if (action == null) {
            SliceStream.$$$reportNull$$$0(3);
        }
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, action);
    }

    public TraceEventModel findFirst() {
        TraceEventModel[] events = new TraceEventModel[1];
        SliceStream.forEachMatchingSlice(this.mySlices, this.myPattern, this.myRange, sliceGroup -> {
            events[0] = sliceGroup;
            return EnumerationResult.TERMINATE;
        });
        return events[0];
    }

    private static EnumerationResult forEachMatchingSlice(@NotNull List<TraceEventModel> eventGroups, @NotNull Pattern pattern, @NotNull Range range, Function<TraceEventModel, EnumerationResult> action) {
        if (eventGroups == null) {
            SliceStream.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            SliceStream.$$$reportNull$$$0(5);
        }
        if (range == null) {
            SliceStream.$$$reportNull$$$0(6);
        }
        for (TraceEventModel event : eventGroups) {
            EnumerationResult result;
            if (!((double)event.getStartTimestampUs() <= range.getMax()) || !((double)event.getEndTimestampUs() >= range.getMin())) continue;
            boolean skipChildren = false;
            if (pattern.matcher(event.getName()).matches()) {
                EnumerationResult continueResult = action.apply(event);
                if (continueResult == EnumerationResult.TERMINATE) {
                    return continueResult;
                }
                boolean bl = skipChildren = continueResult == EnumerationResult.SKIP_CHILDREN;
            }
            if (skipChildren || (result = SliceStream.forEachMatchingSlice(event.getChildrenEvents(), pattern, range, action)) != EnumerationResult.TERMINATE) continue;
            return result;
        }
        return EnumerationResult.CONTINUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slices";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventGroups";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/systemtrace/SliceStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matchPattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "matchName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachMatchingSlice";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum EnumerationResult {
        CONTINUE,
        TERMINATE,
        SKIP_CHILDREN;

    }
}

