/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.DurationData;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.annotations.NotNull;

public class SystemTraceFrame
implements DurationData {
    public static final SystemTraceFrame EMPTY = new SystemTraceFrame(0L, 0L, 0.0, 0L, FrameThread.OTHER);
    private static final String APP_MAIN_THREAD_FRAME_ID_MPLUS = "Choreographer#doFrame";
    private static final String APP_RENDER_THREAD_FRAME_ID_MPLUS = "(DrawFrame|doFrame|queueBuffer)";
    private SystemTraceFrame myAssociatedFrame;
    private final long myStartUs;
    private final long myEndUs;
    private final double myCpuTimeUs;
    private final long myLongFrameTimeUs;
    @NotNull
    private final PerfClass myPerfClass;
    private final FrameThread myThread;

    /*
     * WARNING - void declaration
     */
    public SystemTraceFrame(@NotNull TraceEventModel eventModel, long longFrameTimeUs, FrameThread frameThread) {
        void thread2;
        if (eventModel == null) {
            SystemTraceFrame.$$$reportNull$$$0(0);
        }
        this(eventModel.getStartTimestampUs(), eventModel.getEndTimestampUs(), eventModel.getCpuTimeUs(), longFrameTimeUs, (FrameThread)thread2);
    }

    @VisibleForTesting
    public SystemTraceFrame(long startUs, long endUs, double cpuTimeUs, long longFrameTimeUs, FrameThread thread2) {
        this.myStartUs = startUs;
        this.myEndUs = endUs;
        this.myCpuTimeUs = cpuTimeUs;
        this.myLongFrameTimeUs = longFrameTimeUs;
        this.myThread = thread2;
        this.myPerfClass = this.getDurationUs() > this.myLongFrameTimeUs ? PerfClass.BAD : PerfClass.GOOD;
    }

    public FrameThread getThread() {
        return this.myThread;
    }

    public void setAssociatedFrame(SystemTraceFrame associatedFrame) {
        this.myAssociatedFrame = associatedFrame;
    }

    public SystemTraceFrame getAssociatedFrame() {
        return this.myAssociatedFrame;
    }

    public long getStartUs() {
        return this.myStartUs;
    }

    public long getEndUs() {
        return this.myEndUs;
    }

    @NotNull
    public PerfClass getPerfClass() {
        PerfClass perfClass = this.myPerfClass;
        if (perfClass == null) {
            SystemTraceFrame.$$$reportNull$$$0(1);
        }
        return perfClass;
    }

    public PerfClass getTotalPerfClass() {
        double associatedFrameLengthUs;
        if (this == EMPTY || this.myPerfClass == PerfClass.NOT_SET) {
            return PerfClass.NOT_SET;
        }
        double d = associatedFrameLengthUs = this.myAssociatedFrame == null ? 0.0 : (double)this.myAssociatedFrame.getDurationUs();
        if (associatedFrameLengthUs + (double)this.getDurationUs() > (double)this.myLongFrameTimeUs) {
            return PerfClass.BAD;
        }
        return PerfClass.GOOD;
    }

    public long getDurationUs() {
        return this.getEndUs() - this.getStartUs();
    }

    public double getCpuTimeUs() {
        return this.myCpuTimeUs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/systemtrace/SystemTraceFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/systemtrace/SystemTraceFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerfClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum FrameThread {
        MAIN("Choreographer#doFrame"),
        RENDER("(DrawFrame|doFrame|queueBuffer)"),
        OTHER("");

        private final String myIdentifierRegEx;

        public String getIdentifierRegEx() {
            return this.myIdentifierRegEx;
        }

        private FrameThread(String identifierRegEx) {
            this.myIdentifierRegEx = identifierRegEx;
        }
    }

    public static enum PerfClass {
        NOT_SET,
        GOOD,
        BAD;

    }
}

