/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleEventModel;
import com.android.tools.adtui.model.trackgroup.TrackGroupModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.customevent.CustomEventTrackModel;
import com.android.tools.profilers.customevent.UserCounterAspectModel;
import com.android.tools.profilers.customevent.UserCounterModel;
import com.android.tools.profilers.event.LifecycleEventDataSeries;
import com.android.tools.profilers.event.UserEventDataSeries;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomEventProfilerStage
extends StreamingStage {
    private final List<TrackGroupModel> myTrackGroupModels;
    @NotNull
    private final List<UserCounterModel> myUserCounterModels;
    @NotNull
    private final AspectObserver myAspectObserver;
    @NotNull
    private final UserCounterAspectModel myUserCounterAspectModel;
    @NotNull
    private final TrackGroupModel myEventTrackGroupModel;

    public CustomEventProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CustomEventProfilerStage.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myTrackGroupModels = new ArrayList<TrackGroupModel>();
        this.myUserCounterModels = new ArrayList<UserCounterModel>();
        this.myAspectObserver = new AspectObserver();
        this.myUserCounterAspectModel = new UserCounterAspectModel();
        this.myEventTrackGroupModel = TrackGroupModel.newBuilder().setTitle("Custom Events").build();
        this.getTimeline().getViewRange().addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::updateEventNames);
        this.updateEventNames();
    }

    @Override
    public void enter() {
        this.logEnterStage();
        this.initTrackGroupList();
    }

    @Override
    public void exit() {
        for (UserCounterModel model : this.myUserCounterModels) {
            this.getStudioProfilers().getUpdater().unregister((Updatable)model);
        }
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.UNKNOWN_STAGE;
    }

    private void initTrackGroupList() {
        this.myTrackGroupModels.clear();
        this.myTrackGroupModels.add(this.createInteractionTrackGroup());
        this.myTrackGroupModels.add(this.myEventTrackGroupModel);
        for (String eventName : this.myUserCounterAspectModel.getEventNames()) {
            this.myEventTrackGroupModel.addTrackModel(TrackModel.newBuilder((Object)this.createTrackModel(eventName), (Enum)ProfilerTrackRendererType.CUSTOM_EVENTS, (String)eventName).setHideHeader(true));
        }
    }

    private CustomEventTrackModel createTrackModel(String eventName) {
        UserCounterModel dataModel = new UserCounterModel(this.getStudioProfilers(), eventName);
        this.getStudioProfilers().getUpdater().register((Updatable)dataModel);
        this.myUserCounterModels.add(dataModel);
        Range dataRange = this.getTimeline().getDataRange();
        return new CustomEventTrackModel(dataModel, dataRange);
    }

    private TrackGroupModel createInteractionTrackGroup() {
        Range viewRange = this.getTimeline().getViewRange();
        TrackGroupModel interaction = TrackGroupModel.newBuilder().setTitle("Interaction").build();
        interaction.addTrackModel(TrackModel.newBuilder((Object)new EventModel(new RangedSeries(viewRange, (DataSeries)new UserEventDataSeries(this.getStudioProfilers()))), (Enum)ProfilerTrackRendererType.USER_INTERACTION, (String)"User"));
        interaction.addTrackModel(TrackModel.newBuilder((Object)new LifecycleEventModel(new RangedSeries(viewRange, (DataSeries)new LifecycleEventDataSeries(this.getStudioProfilers(), false)), new RangedSeries(viewRange, (DataSeries)new LifecycleEventDataSeries(this.getStudioProfilers(), true))), (Enum)ProfilerTrackRendererType.APP_LIFECYCLE, (String)"Lifecycle"));
        return interaction;
    }

    @NotNull
    public List<TrackGroupModel> getTrackGroupModels() {
        List<TrackGroupModel> list = this.myTrackGroupModels;
        if (list == null) {
            CustomEventProfilerStage.$$$reportNull$$$0(1);
        }
        return list;
    }

    @VisibleForTesting
    void updateEventNames() {
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.getStudioProfilers().getSession().getStreamId()).setPid(this.getStudioProfilers().getSession().getPid()).setKind(Common.Event.Kind.USER_COUNTERS).build();
        Transport.GetEventGroupsResponse response = this.getStudioProfilers().getClient().getTransportClient().getEventGroups(request);
        if (this.myTrackGroupModels.isEmpty()) {
            this.initTrackGroupList();
        }
        if (response.getGroupsCount() > this.myUserCounterAspectModel.getSize()) {
            for (Transport.EventGroup eventGroup : response.getGroupsList()) {
                String eventName;
                if (eventGroup.getEventsCount() <= 0 || !this.myUserCounterAspectModel.add(eventName = ((Common.Event)eventGroup.getEventsList().get(0)).getUserCounters().getName())) continue;
                this.myEventTrackGroupModel.addTrackModel(TrackModel.newBuilder((Object)this.createTrackModel(eventName), (Enum)ProfilerTrackRendererType.CUSTOM_EVENTS, (String)eventName).setHideHeader(true));
            }
        }
    }

    @NotNull
    public UserCounterAspectModel getUserCounterAspectModel() {
        UserCounterAspectModel userCounterAspectModel = this.myUserCounterAspectModel;
        if (userCounterAspectModel == null) {
            CustomEventProfilerStage.$$$reportNull$$$0(2);
        }
        return userCounterAspectModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/customevent/CustomEventProfilerStage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/customevent/CustomEventProfilerStage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackGroupModels";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserCounterAspectModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

