/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.inspectors.common.api.stacktrace.StackTraceModel;
import com.android.tools.inspectors.common.ui.stacktrace.StackTraceGroup;
import com.android.tools.inspectors.common.ui.stacktrace.StackTraceView;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnergyCallstackView
extends JPanel {
    @NotNull
    private final EnergyProfilerStageView myStageView;

    public EnergyCallstackView(@NotNull EnergyProfilerStageView stageView) {
        if (stageView == null) {
            EnergyCallstackView.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new VerticalFlowLayout(0, JBUIScale.scale((int)5)));
        this.myStageView = stageView;
    }

    public void setDuration(@Nullable EnergyDuration duration) {
        this.removeAll();
        if (duration == null) {
            return;
        }
        ArrayList<HideablePanel> callstackList = new ArrayList<HideablePanel>();
        StackTraceGroup stackTraceGroup = this.myStageView.getIdeComponents().createStackGroup();
        long startTimeNs = ((EnergyProfilerStage)((Object)this.myStageView.getStage())).getStudioProfilers().getSession().getStartTimestamp();
        for (Common.Event event : duration.getEventList()) {
            if (event.getEnergyEvent().getCallstack().isEmpty() || EnergyDuration.getMetadataName(event.getEnergyEvent().getMetadataCase()).isEmpty()) continue;
            String callstackString = event.getEnergyEvent().getCallstack();
            StackTraceModel model = new StackTraceModel(((EnergyProfilerStage)((Object)this.myStageView.getStage())).getStudioProfilers().getIdeServices().getCodeNavigator());
            StackTraceView stackTraceView = stackTraceGroup.createStackView(model);
            stackTraceView.getModel().setStackFrames(callstackString);
            JComponent traceComponent = stackTraceView.getComponent();
            if (traceComponent instanceof JScrollPane) {
                traceComponent = (JComponent)((JScrollPane)traceComponent).getViewport().getComponent(0);
                traceComponent.setBorder((Border)new JBEmptyBorder(0, 0, 12, 0));
                JPanel wrapperPanel = new JPanel(new BorderLayout());
                wrapperPanel.add((Component)traceComponent, "Center");
                wrapperPanel.setBackground(traceComponent.getBackground());
                traceComponent = AdtUiUtils.createNestedVScrollPane((JComponent)wrapperPanel);
            }
            String time = TimeFormatter.getFullClockString((long)TimeUnit.NANOSECONDS.toMicros(event.getTimestamp() - startTimeNs));
            String description = time + "&nbsp;&nbsp;" + EnergyDuration.getMetadataName(event.getEnergyEvent().getMetadataCase());
            HideablePanel hideablePanel = new HideablePanel.Builder(description, traceComponent).setContentBorder((Border)new JBEmptyBorder(5, 0, 0, 0)).setPanelBorder((Border)new JBEmptyBorder(0, 0, 0, 0)).setTitleRightPadding(0).build();
            hideablePanel.setBackground(null);
            callstackList.add(hideablePanel);
        }
        if (callstackList.size() > 2) {
            callstackList.forEach(c -> c.setExpanded(false));
        }
        JLabel label = new JLabel("<html><b>Callstacks</b>: " + callstackList.size() + "</html>");
        label.setBorder((Border)new JBEmptyBorder(0, 0, 4, 0));
        this.add(label);
        callstackList.forEach(c -> this.add((Component)c));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stageView", "com/android/tools/profilers/energy/EnergyCallstackView", "<init>"));
    }
}

