/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Energy;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class EnergyDuration
implements Comparable<EnergyDuration> {
    @NotNull
    private final ImmutableList<Common.Event> myEventList;
    private String myCalledBy;

    public EnergyDuration(@NotNull List<Common.Event> eventList) {
        if (eventList == null) {
            EnergyDuration.$$$reportNull$$$0(0);
        }
        this.myCalledBy = null;
        assert (!eventList.isEmpty());
        this.myEventList = ImmutableList.copyOf(eventList);
    }

    @Override
    public int compareTo(@NotNull EnergyDuration another) {
        if (another == null) {
            EnergyDuration.$$$reportNull$$$0(1);
        }
        return (int)(this.getInitialTimestamp() - another.getInitialTimestamp());
    }

    public long getInitialTimestamp() {
        return ((Common.Event)this.myEventList.get(0)).getTimestamp();
    }

    @NotNull
    public String getName() {
        Kind kind = this.getKind();
        String namePart = "";
        switch (kind) {
            case WAKE_LOCK: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasWakeLockAcquired()) break;
                namePart = EnergyDuration.getWakeLockLevelName(((Common.Event)this.getEventList().get(0)).getEnergyEvent().getWakeLockAcquired().getLevel());
                break;
            }
            case ALARM: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasAlarmSet()) break;
                namePart = EnergyDuration.getAlarmTypeName(((Common.Event)this.getEventList().get(0)).getEnergyEvent().getAlarmSet().getType());
                break;
            }
            case LOCATION: {
                namePart = "Request";
                break;
            }
        }
        String string = !namePart.isEmpty() ? String.format("%s: %s", kind.getDisplayName(), namePart) : kind.getDisplayName();
        if (string == null) {
            EnergyDuration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        switch (this.getKind()) {
            case WAKE_LOCK: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasWakeLockAcquired()) break;
                String string = ((Common.Event)this.getEventList().get(0)).getEnergyEvent().getWakeLockAcquired().getTag();
                if (string == null) {
                    EnergyDuration.$$$reportNull$$$0(3);
                }
                return string;
            }
            case ALARM: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasAlarmSet()) break;
                Energy.AlarmSet alarmSet = ((Common.Event)this.getEventList().get(0)).getEnergyEvent().getAlarmSet();
                return alarmSet.hasOperation() ? alarmSet.getOperation().getCreatorPackage() : (alarmSet.hasListener() ? alarmSet.getListener().getTag() : "");
            }
            case JOB: {
                if (!((Common.Event)this.getEventList().get(0)).getEnergyEvent().hasJobScheduled()) break;
                Energy.JobInfo job = ((Common.Event)this.getEventList().get(0)).getEnergyEvent().getJobScheduled().getJob();
                String string = String.format("%d:%s", job.getJobId(), job.getServiceName());
                if (string == null) {
                    EnergyDuration.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        return "N/A";
    }

    @NotNull
    public Kind getKind() {
        Kind kind = Kind.from(((Common.Event)this.myEventList.get(0)).getEnergyEvent());
        if (kind == null) {
            EnergyDuration.$$$reportNull$$$0(5);
        }
        return kind;
    }

    @NotNull
    public ImmutableList<Common.Event> getEventList() {
        ImmutableList<Common.Event> immutableList = this.myEventList;
        if (immutableList == null) {
            EnergyDuration.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @NotNull
    public static List<EnergyDuration> groupById(@NotNull List<Common.Event> events) {
        if (events == null) {
            EnergyDuration.$$$reportNull$$$0(7);
        }
        LinkedHashMap durationMap = new LinkedHashMap();
        for (Common.Event event : events) {
            if (durationMap.containsKey(event.getGroupId())) {
                ((List)durationMap.get(event.getGroupId())).add(event);
                continue;
            }
            ArrayList<Common.Event> list2 = new ArrayList<Common.Event>();
            list2.add(event);
            durationMap.put(event.getGroupId(), list2);
        }
        List list3 = ContainerUtil.map(durationMap.values(), list -> new EnergyDuration((List<Common.Event>)list));
        if (list3 == null) {
            EnergyDuration.$$$reportNull$$$0(8);
        }
        return list3;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(EnergyDuration.class);
        if (logger == null) {
            EnergyDuration.$$$reportNull$$$0(9);
        }
        return logger;
    }

    @NotNull
    public static String getWakeLockLevelName(@NotNull Energy.WakeLockAcquired.Level level) {
        if (level == null) {
            EnergyDuration.$$$reportNull$$$0(10);
        }
        switch (level) {
            case FULL_WAKE_LOCK: {
                return "Full";
            }
            case PARTIAL_WAKE_LOCK: {
                return "Partial";
            }
            case SCREEN_DIM_WAKE_LOCK: {
                return "Screen Dim";
            }
            case SCREEN_BRIGHT_WAKE_LOCK: {
                return "Screen Bright";
            }
            case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                return "Proximity Screen Off";
            }
        }
        return "N/A";
    }

    @NotNull
    public static String getAlarmTypeName(@NotNull Energy.AlarmSet.Type type) {
        if (type == null) {
            EnergyDuration.$$$reportNull$$$0(11);
        }
        switch (type) {
            case RTC: {
                return "RTC";
            }
            case RTC_WAKEUP: {
                return "RTC Wakeup";
            }
            case ELAPSED_REALTIME: {
                return "Elapsed Realtime";
            }
            case ELAPSED_REALTIME_WAKEUP: {
                return "Elapsed Realtime Wakeup";
            }
        }
        return "N/A";
    }

    @NotNull
    public static String getMetadataName(Energy.EnergyEventData.MetadataCase metadataCase) {
        switch (metadataCase) {
            case WAKE_LOCK_ACQUIRED: {
                return "Acquired";
            }
            case WAKE_LOCK_RELEASED: {
                return "Released";
            }
            case ALARM_SET: {
                return "Set";
            }
            case ALARM_FIRED: {
                return "Triggered";
            }
            case ALARM_CANCELLED: {
                return "Cancelled";
            }
            case JOB_SCHEDULED: {
                return "Scheduled";
            }
            case JOB_STARTED: {
                return "Started";
            }
            case JOB_STOPPED: {
                return "Stopped";
            }
            case JOB_FINISHED: {
                return "Finished";
            }
            case LOCATION_UPDATE_REQUESTED: {
                return "Requested";
            }
            case LOCATION_CHANGED: {
                return "Location Updated";
            }
            case LOCATION_UPDATE_REMOVED: {
                return "Request Removed";
            }
        }
        return "";
    }

    @NotNull
    public String getCalledBy() {
        if (this.myCalledBy == null) {
            this.myCalledBy = this.getEventList().stream().filter(e -> !e.getEnergyEvent().getCallstack().isEmpty()).map(e -> e.getEnergyEvent().getCallstack().split("\\(", 2)).filter(splitResult -> ((String[])splitResult).length > 0).map(splitResult -> splitResult[0]).findFirst().orElse("");
        }
        String string = this.myCalledBy;
        if (string == null) {
            EnergyDuration.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnergyDuration duration = (EnergyDuration)o;
        return this.myEventList.equals(duration.myEventList);
    }

    public int hashCode() {
        return Objects.hash(this.myEventList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyDuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyDuration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "groupById";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalledBy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "groupById";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWakeLockLevelName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlarmTypeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 8, 9, 12 -> new IllegalStateException(string);
        };
    }

    public static enum Kind {
        UNKNOWN("N/A"),
        WAKE_LOCK("Wake Lock"),
        ALARM("Alarm"),
        JOB("Job"),
        LOCATION("Location");

        @NotNull
        private final String myDisplayName;

        @NotNull
        public static Kind from(@NotNull Energy.EnergyEventData event) {
            if (event == null) {
                Kind.$$$reportNull$$$0(0);
            }
            switch (event.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: 
                case WAKE_LOCK_RELEASED: {
                    Kind kind = WAKE_LOCK;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(1);
                    }
                    return kind;
                }
                case ALARM_SET: 
                case ALARM_FIRED: 
                case ALARM_CANCELLED: {
                    Kind kind = ALARM;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(2);
                    }
                    return kind;
                }
                case JOB_SCHEDULED: 
                case JOB_STARTED: 
                case JOB_STOPPED: 
                case JOB_FINISHED: {
                    Kind kind = JOB;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(3);
                    }
                    return kind;
                }
                case LOCATION_UPDATE_REQUESTED: 
                case LOCATION_UPDATE_REMOVED: 
                case LOCATION_CHANGED: {
                    Kind kind = LOCATION;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(4);
                    }
                    return kind;
                }
            }
            EnergyDuration.getLogger().warn("Unsupported Kind for " + event.getMetadataCase().name());
            Kind kind = UNKNOWN;
            if (kind == null) {
                Kind.$$$reportNull$$$0(5);
            }
            return kind;
        }

        private Kind(String displayName) {
            if (displayName == null) {
                Kind.$$$reportNull$$$0(6);
            }
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                Kind.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/energy/EnergyDuration$Kind";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/energy/EnergyDuration$Kind";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }
}

