/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.EnergyAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyMonitorTooltip;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyUsage;
import org.jetbrains.annotations.NotNull;

public class EnergyMonitor
extends ProfilerMonitor {
    public static final int MAX_EXPECTED_USAGE = 400;
    public static final Range AXIS_MARKER_RANGE = new Range(0.0, (double)(200 * EnergyAxisFormatter.LABELS.length));
    @NotNull
    private final EnergyUsage myUsage;
    @NotNull
    private final ClampedAxisComponentModel myAxis;
    @NotNull
    private final Legends myLegends;
    @NotNull
    private final Legends myTooltipLegends;

    public EnergyMonitor(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            EnergyMonitor.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myUsage = new EnergyUsage(profilers);
        this.myAxis = (ClampedAxisComponentModel)new ClampedAxisComponentModel.Builder(this.myUsage.getUsageRange(), (BaseAxisFormatter)EnergyAxisFormatter.DEFAULT).setMarkerRange(AXIS_MARKER_RANGE).build();
        this.myLegends = new Legends(this.myUsage, this.getTimeline().getDataRange());
        this.myTooltipLegends = new Legends(this.myUsage, this.getTimeline().getTooltipRange());
        this.changed(ProfilerMonitor.Aspect.ENABLE);
    }

    @Override
    public String getName() {
        return "ENERGY";
    }

    @Override
    public TooltipModel buildTooltip() {
        return new EnergyMonitorTooltip(this);
    }

    @Override
    public void expand() {
        if (this.canExpand()) {
            this.myProfilers.setStage(new EnergyProfilerStage(this.getProfilers()));
        }
    }

    @Override
    public boolean canExpand() {
        return this.isEnabled();
    }

    @Override
    public void enter() {
        if (this.isEnabled()) {
            this.myProfilers.getUpdater().register((Updatable)this.myUsage);
            this.myProfilers.getUpdater().register((Updatable)this.myAxis);
        }
    }

    @Override
    public void exit() {
        if (this.isEnabled()) {
            this.myProfilers.getUpdater().unregister((Updatable)this.myUsage);
            this.myProfilers.getUpdater().unregister((Updatable)this.myAxis);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.myProfilers.getSession().getSessionId() != 0L) {
            return this.myProfilers.getSessionsManager().getSelectedSessionMetaData().getJvmtiEnabled();
        }
        return this.myProfilers.getDevice() == null || this.myProfilers.getDevice().getFeatureLevel() >= 26;
    }

    @NotNull
    public EnergyUsage getUsage() {
        EnergyUsage energyUsage = this.myUsage;
        if (energyUsage == null) {
            EnergyMonitor.$$$reportNull$$$0(1);
        }
        return energyUsage;
    }

    @NotNull
    public AxisComponentModel getAxis() {
        ClampedAxisComponentModel clampedAxisComponentModel = this.myAxis;
        if (clampedAxisComponentModel == null) {
            EnergyMonitor.$$$reportNull$$$0(2);
        }
        return clampedAxisComponentModel;
    }

    @NotNull
    public Legends getLegends() {
        Legends legends = this.myLegends;
        if (legends == null) {
            EnergyMonitor.$$$reportNull$$$0(3);
        }
        return legends;
    }

    @NotNull
    public Legends getTooltipLegends() {
        Legends legends = this.myTooltipLegends;
        if (legends == null) {
            EnergyMonitor.$$$reportNull$$$0(4);
        }
        return legends;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAxis";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegends";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipLegends";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static final class Legends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myUsageLegend;

        public Legends(@NotNull EnergyUsage usage, @NotNull Range range) {
            if (usage == null) {
                Legends.$$$reportNull$$$0(0);
            }
            if (range == null) {
                Legends.$$$reportNull$$$0(1);
            }
            super(range);
            this.myUsageLegend = new SeriesLegend(usage.getTotalUsageDataSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range);
            this.add((Legend)this.myUsageLegend);
        }

        @NotNull
        public SeriesLegend getUsageLegend() {
            SeriesLegend seriesLegend = this.myUsageLegend;
            if (seriesLegend == null) {
                Legends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/energy/EnergyMonitor$Legends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/energy/EnergyMonitor$Legends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsageLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

