/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.ActivityComponent;
import com.android.tools.adtui.EventComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.eventrenderer.EventIconRenderer;
import com.android.tools.adtui.eventrenderer.EventRenderer;
import com.android.tools.adtui.eventrenderer.KeyboardEventRenderer;
import com.android.tools.adtui.eventrenderer.TouchEventRenderer;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.UserEventTooltip;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EventMonitorView
extends ProfilerMonitorView<EventMonitor> {
    private static final Map<UserEvent, EventRenderer<UserEvent>> RENDERERS = new HashMap<UserEvent, EventRenderer<UserEvent>>();
    private EventComponent<UserEvent> myUserEventComponent;
    private ActivityComponent myActivityComponent;

    public EventMonitorView(@NotNull StudioProfilersView profilersView, @NotNull EventMonitor monitor) {
        if (profilersView == null) {
            EventMonitorView.$$$reportNull$$$0(0);
        }
        if (monitor == null) {
            EventMonitorView.$$$reportNull$$$0(1);
        }
        super(monitor);
        this.initializeComponents();
    }

    private void initializeComponents() {
        if (this.myActivityComponent == null) {
            this.myActivityComponent = new ActivityComponent(((EventMonitor)((Object)this.getMonitor())).getLifecycleEvents());
        }
        if (this.myUserEventComponent == null) {
            this.myUserEventComponent = new EventComponent(((EventMonitor)((Object)this.getMonitor())).getUserEvents(), RENDERERS);
        }
    }

    @Override
    public float getVerticalWeight() {
        return 0.0f;
    }

    @Override
    public void registerTooltip(@NotNull RangeTooltipComponent tooltip, Stage stage) {
        if (tooltip == null) {
            EventMonitorView.$$$reportNull$$$0(2);
        }
        this.registerComponent((JComponent)this.myUserEventComponent, () -> new UserEventTooltip(((EventMonitor)((Object)((Object)this.getMonitor()))).getTimeline(), ((EventMonitor)((Object)((Object)this.getMonitor()))).getUserEvents()), tooltip, stage);
        this.registerComponent((JComponent)this.myActivityComponent, () -> new LifecycleTooltip(((EventMonitor)((Object)((Object)this.getMonitor()))).getTimeline(), ((EventMonitor)((Object)((Object)this.getMonitor()))).getLifecycleEvents()), tooltip, stage);
    }

    private void registerComponent(JComponent component, final Supplier<TooltipModel> tooltipBuilder, RangeTooltipComponent tooltipComponent, final Stage stage) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((EventMonitor)EventMonitorView.this.getMonitor()).isEnabled()) {
                    ((EventMonitor)EventMonitorView.this.getMonitor()).setTooltipBuilder(tooltipBuilder);
                    stage.setTooltip(((EventMonitor)EventMonitorView.this.getMonitor()).buildTooltip());
                } else {
                    stage.setTooltip(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                stage.setTooltip(null);
            }
        });
        tooltipComponent.registerListenersOn(component);
    }

    @Override
    protected void populateUi(JPanel container) {
        this.initializeComponents();
        container.setLayout((LayoutManager)new TabularLayout("*", "*,*"));
        container.add((Component)this.myUserEventComponent, new TabularLayout.Constraint(0, 0));
        container.add((Component)this.myActivityComponent, new TabularLayout.Constraint(1, 0));
    }

    static {
        RENDERERS.put(UserEvent.TOUCH, (EventRenderer<UserEvent>)new TouchEventRenderer());
        RENDERERS.put(UserEvent.ROTATION, (EventRenderer<UserEvent>)new EventIconRenderer(StudioIcons.Profiler.Events.ROTATE_EVENT));
        RENDERERS.put(UserEvent.KEYBOARD, (EventRenderer<UserEvent>)new KeyboardEventRenderer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "monitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/event/EventMonitorView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

