/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.LifecycleAction;
import com.android.tools.adtui.model.event.LifecycleEvent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Interaction;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LifecycleEventDataSeries
implements DataSeries<EventAction<LifecycleEvent>> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    private final boolean myFragmentsOnly;

    public LifecycleEventDataSeries(@NotNull StudioProfilers profilers, boolean fragmentOnly) {
        if (profilers == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(0);
        }
        this.myProfilers = profilers;
        this.mySession = profilers.getSession();
        this.myFragmentsOnly = fragmentOnly;
    }

    public List<SeriesData<EventAction<LifecycleEvent>>> getDataForRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(1);
        }
        return this.getTransportData(timeCurrentRangeUs);
    }

    @NotNull
    private List<SeriesData<EventAction<LifecycleEvent>>> getTransportData(@NotNull Range rangeUs) {
        if (rangeUs == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(2);
        }
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> series = new ArrayList<SeriesData<EventAction<LifecycleEvent>>>();
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.VIEW).setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            boolean isFragment;
            boolean bl = isFragment = group.getEvents(0).getView().getParentActivityId() != 0L;
            if (this.myFragmentsOnly != isFragment) continue;
            long actionStart = 0L;
            long actionEnd = 0L;
            boolean hasEndEvent = false;
            LifecycleEvent lifecycleEvent = LifecycleEvent.NONE;
            for (int i = 0; i < group.getEventsCount(); ++i) {
                Common.Event event = group.getEvents(i);
                Interaction.ViewData data2 = event.getView();
                Object displayString = data2.getName();
                switch (data2.getState()) {
                    case ADDED: 
                    case RESUMED: {
                        lifecycleEvent = LifecycleEvent.STARTED;
                        actionStart = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                        break;
                    }
                    case DESTROYED: {
                        if (i != group.getEventsCount() - 1) break;
                        displayString = (String)displayString + String.format(" - %s", data2.getState().toString().toLowerCase());
                    }
                    case REMOVED: 
                    case PAUSED: {
                        lifecycleEvent = LifecycleEvent.COMPLETED;
                        actionEnd = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                        hasEndEvent = true;
                        break;
                    }
                }
                if (hasEndEvent) {
                    while (++i < group.getEventsCount()) {
                        Common.Event nextEvent = group.getEvents(i);
                        if (nextEvent.getIsEnded()) {
                            displayString = (String)displayString + String.format(" - %s", nextEvent.getView().getState().toString().toLowerCase());
                            continue;
                        }
                        --i;
                        break;
                    }
                }
                if (!hasEndEvent && (i != group.getEventsCount() - 1 || actionStart == 0L)) continue;
                series.add((SeriesData<EventAction<LifecycleEvent>>)new SeriesData(actionStart, (Object)new LifecycleAction(actionStart, actionEnd, lifecycleEvent, (String)displayString, event.getGroupId())));
                actionStart = 0L;
                actionEnd = 0L;
                hasEndEvent = false;
                lifecycleEvent = LifecycleEvent.NONE;
            }
        }
        series.sort(Comparator.comparingLong(data -> data.x));
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> arrayList = series;
        if (arrayList == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeUs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/event/LifecycleEventDataSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/event/LifecycleEventDataSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransportData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataForRange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTransportData";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

