/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.AllocationSessionArtifactKt;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.sessions.SessionArtifact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001bR\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006,"}, d2={"Lcom/android/tools/profilers/memory/AllocationSessionArtifact;", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "info", "startUs", "", "endUs", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profiler/proto/Common$Session;Lcom/android/tools/profiler/proto/Common$SessionMetaData;Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;DD)V", "artifactProto", "getArtifactProto", "()Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "canExport", "", "getCanExport", "()Z", "getEndUs", "()D", "isOngoing", "name", "", "getName", "()Ljava/lang/String;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getSession", "()Lcom/android/tools/profiler/proto/Common$Session;", "getSessionMetaData", "()Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "getStartUs", "subtitle", "getSubtitle", "timestampNs", "", "getTimestampNs", "()J", "doSelect", "", "Companion", "intellij.android.profilers"})
public final class AllocationSessionArtifact
implements SessionArtifact<Memory.AllocationsInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Common.Session session;
    @NotNull
    private final Common.SessionMetaData sessionMetaData;
    @NotNull
    private final Memory.AllocationsInfo info;
    private final double startUs;
    private final double endUs;
    @NotNull
    private final Memory.AllocationsInfo artifactProto;
    @NotNull
    private final String name;
    private final boolean canExport;

    public AllocationSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull Memory.AllocationsInfo info, double startUs, double endUs) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionMetaData, (String)"sessionMetaData");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.profilers = profilers;
        this.session = session;
        this.sessionMetaData = sessionMetaData;
        this.info = info;
        this.startUs = startUs;
        this.endUs = endUs;
        this.artifactProto = this.info;
        this.name = "Allocation Records";
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.profilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.sessionMetaData;
    }

    public final double getStartUs() {
        return this.startUs;
    }

    public final double getEndUs() {
        return this.endUs;
    }

    @NotNull
    public final String getSubtitle() {
        String string = TimeFormatter.getFullClockString((long)AllocationSessionArtifactKt.access$nanosToMicros(this.getTimestampNs()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullClockString(timestampNs.nanosToMicros())");
        return string;
    }

    @Override
    @NotNull
    public Memory.AllocationsInfo getArtifactProto() {
        return this.artifactProto;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimestampNs() {
        return this.info.getStartTime() - this.getSession().getStartTimestamp();
    }

    @Override
    public boolean isOngoing() {
        return this.info.getEndTime() == Long.MAX_VALUE;
    }

    @Override
    public boolean getCanExport() {
        return this.canExport;
    }

    @Override
    public void doSelect() {
        if (this.getSession() != this.getProfilers().getSession()) {
            this.getProfilers().getSessionsManager().setSession(this.getSession());
        }
        this.getProfilers().setStage(AllocationStage.Companion.makeStaticStage$default(AllocationStage.Companion, this.getProfilers(), null, this.startUs, this.endUs, 2, null));
    }

    @JvmStatic
    @NotNull
    public static final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetadata) {
        return Companion.getSessionArtifacts(profilers, session, sessionMetadata);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/profilers/memory/AllocationSessionArtifact$Companion;", "", "()V", "getSessionArtifacts", "", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetadata", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nAllocationSessionArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocationSessionArtifact.kt\ncom/android/tools/profilers/memory/AllocationSessionArtifact$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1603#2,9:75\n1855#2:84\n1856#2:86\n1612#2:87\n1#3:85\n*S KotlinDebug\n*F\n+ 1 AllocationSessionArtifact.kt\ncom/android/tools/profilers/memory/AllocationSessionArtifact$Companion\n*L\n61#1:75,9\n61#1:84\n61#1:86\n61#1:87\n61#1:85\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetadata) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)sessionMetadata, (String)"sessionMetadata");
            Range rangeUs = new Range((double)AllocationSessionArtifactKt.access$nanosToMicros(session.getStartTimestamp()), (double)AllocationSessionArtifactKt.access$nanosToMicros(session.getEndTimestamp()));
            ProfilerClient profilerClient = profilers.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"profilers.client");
            Iterable $this$mapNotNull$iv = MemoryProfiler.Companion.getAllocationInfosForSession(profilerClient, session, rangeUs);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Memory.AllocationsInfo info = (Memory.AllocationsInfo)element$iv$iv;
                boolean bl2 = false;
                SessionArtifact it$iv$iv = info.getLegacy() ? (SessionArtifact)new LegacyAllocationsSessionArtifact(profilers, session, sessionMetadata, info) : (SessionArtifact)new AllocationSessionArtifact(profilers, session, sessionMetadata, info, AllocationSessionArtifactKt.access$nanosToMicros(info.getStartTime()), AllocationSessionArtifactKt.access$nanosToMicros(info.getEndTime()));
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

