/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 :2\u00020\u0001:\u0001:B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020\u0014J\b\u0010.\u001a\u00020\u0014H\u0016J&\u0010/\u001a\u00020#2\u0014\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f012\u0006\u00102\u001a\u000203H\u0014J\b\u00104\u001a\u00020#H\u0002J\u0006\u00105\u001a\u00020#J\b\u00106\u001a\u00020#H\u0014J\b\u00107\u001a\u00020#H\u0002J\b\u00108\u001a\u00020#H\u0007J\u0006\u00109\u001a\u00020#R,\u0010\n\u001a \u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\r \u000e*\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u000f\u001a&\u0012\"\u0012 \u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\r \u000e*\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f0\f0\u000b0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0016\u0010\u001a\u001a\n \u000e*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001f\u00a8\u0006;"}, d2={"Lcom/android/tools/profilers/memory/AllocationStage;", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "loader", "Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "initMinUs", "", "initMaxUs", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profilers/memory/CaptureObjectLoader;DD)V", "allocationDurationData", "Lcom/android/tools/adtui/model/DurationDataModel;", "Lcom/android/tools/profilers/memory/CaptureDurationData;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "kotlin.jvm.PlatformType", "captureSeries", "", "getCaptureSeries", "()Ljava/util/List;", "hasEndedTracking", "", "getHasEndedTracking", "()Z", "hasStartedTracking", "getHasStartedTracking", "isStatic", "lastTrackingEvent", "Lcom/android/tools/profiler/proto/Common$Event;", "<set-?>", "maxTrackingTimeUs", "getMaxTrackingTimeUs", "()D", "minTrackingTimeUs", "getMinTrackingTimeUs", "enter", "", "exit", "getConfirmExitMessage", "", "getHomeStageClass", "Ljava/lang/Class;", "Lcom/android/tools/profilers/memory/MainMemoryProfilerStage;", "getParentStage", "getStageType", "Lcom/google/wireless/android/sdk/stats/AndroidProfilerEvent$Stage;", "isAlmostAllSelected", "isInteractingWithTimeline", "onCaptureToSelect", "captureToSelect", "Lcom/android/tools/adtui/model/SeriesData;", "loadJoiner", "Ljava/util/concurrent/Executor;", "onNewData", "selectAll", "selectCaptureFromSelectionRange", "setupTrackingEventListener", "startLiveDataTimeline", "stopTracking", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nAllocationStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocationStage.kt\ncom/android/tools/profilers/memory/AllocationStage\n+ 2 BaseStreamingMemoryProfilerStage.kt\ncom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage\n*L\n1#1,176:1\n272#2,4:177\n*S KotlinDebug\n*F\n+ 1 AllocationStage.kt\ncom/android/tools/profilers/memory/AllocationStage\n*L\n40#1:177,4\n*E\n"})
public final class AllocationStage
extends BaseStreamingMemoryProfilerStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double minTrackingTimeUs;
    private double maxTrackingTimeUs;
    private Common.Event lastTrackingEvent;
    @NotNull
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> allocationDurationData;

    /*
     * WARNING - void declaration
     */
    private AllocationStage(StudioProfilers profilers, CaptureObjectLoader loader, double initMinUs, double initMaxUs) {
        super(profilers, loader);
        void p3;
        void p2;
        void p1;
        void p0;
        this.minTrackingTimeUs = initMinUs;
        this.maxTrackingTimeUs = initMaxUs;
        this.lastTrackingEvent = Common.Event.getDefaultInstance();
        BaseStreamingMemoryProfilerStage this_$iv = this;
        boolean $i$f$makeModel = false;
        BaseStreamingMemoryProfilerStage this_$iv$iv = this_$iv;
        boolean $i$f$applyDataSeriesConstructor = false;
        ProfilerClient profilerClient = this_$iv$iv.getStudioProfilers().getClient();
        Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"studioProfilers.client");
        BaseMemoryProfilerStage baseMemoryProfilerStage = this_$iv$iv;
        FeatureTracker featureTracker = this_$iv$iv.getStudioProfilers().getIdeServices().getFeatureTracker();
        Common.Session session = BaseStreamingMemoryProfilerStage.access$getSessionData(this_$iv$iv);
        ProfilerClient profilerClient2 = profilerClient;
        BaseStreamingMemoryProfilerStage baseStreamingMemoryProfilerStage = this_$iv;
        AllocationStage allocationStage = this;
        boolean bl = false;
        DataSeries<CaptureDurationData<? extends CaptureObject>> dataSeries = CaptureDataSeries.ofAllocationInfos((ProfilerClient)p0, (Common.Session)p1, (FeatureTracker)p2, (BaseMemoryProfilerStage)p3);
        allocationStage.allocationDurationData = BaseStreamingMemoryProfilerStage.access$makeModel(baseStreamingMemoryProfilerStage, dataSeries);
    }

    public final double getMinTrackingTimeUs() {
        return this.minTrackingTimeUs;
    }

    public final double getMaxTrackingTimeUs() {
        return this.maxTrackingTimeUs;
    }

    private final boolean getHasStartedTracking() {
        return this.minTrackingTimeUs > Double.NEGATIVE_INFINITY;
    }

    public final boolean getHasEndedTracking() {
        return this.maxTrackingTimeUs < Double.POSITIVE_INFINITY;
    }

    public final boolean isStatic() {
        return this.getHasStartedTracking() && this.getHasEndedTracking();
    }

    @Override
    @NotNull
    public List<DurationDataModel<CaptureDurationData<? extends CaptureObject>>> getCaptureSeries() {
        return CollectionsKt.listOf(this.allocationDurationData);
    }

    private final void setupTrackingEventListener() {
        if (this.getStudioProfilers().getSessionsManager().isSessionAlive() && this.isLiveAllocationTrackingSupported()) {
            long currentRangeMax = TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax());
            TransportEventListener listener2 = new TransportEventListener(Common.Event.Kind.MEMORY_ALLOC_TRACKING, this.getStudioProfilers().getIdeServices().getMainExecutor(), (Function1)setupTrackingEventListener.listener.1.INSTANCE, (Function0)new Function0<Long>(this){
                final /* synthetic */ AllocationStage this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Long invoke() {
                    return this.this$0.getSessionData().getStreamId();
                }
            }, (Function0)new Function0<Integer>(this){
                final /* synthetic */ AllocationStage this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return this.this$0.getSessionData().getPid();
                }
            }, null, (Function0)new Function0<Long>(currentRangeMax){
                final /* synthetic */ long $currentRangeMax;
                {
                    this.$currentRangeMax = $currentRangeMax;
                    super(0);
                }

                @NotNull
                public final Long invoke() {
                    return this.$currentRangeMax;
                }
            }, null, (Function1)new Function1<Common.Event, Boolean>(this){
                final /* synthetic */ AllocationStage this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Common.Event it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AllocationStage.access$setLastTrackingEvent$p(this.this$0, it);
                    this.this$0.getAspect().changed((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_STATUS);
                    return true;
                }
            }, 128, null);
            this.getStudioProfilers().getTransportPoller().registerListener(listener2);
        }
    }

    @NotNull
    public MainMemoryProfilerStage getParentStage() {
        return new MainMemoryProfilerStage(this.getStudioProfilers(), this.getLoader());
    }

    @Override
    @NotNull
    public Class<MainMemoryProfilerStage> getHomeStageClass() {
        return MainMemoryProfilerStage.class;
    }

    @Override
    public boolean isInteractingWithTimeline() {
        return false;
    }

    @Override
    @Nullable
    public String getConfirmExitMessage() {
        return this.getHasEndedTracking() ? null : "Going back will end allocation recording. Proceed?";
    }

    @Override
    protected void selectCaptureFromSelectionRange() {
        if (this.getUpdateCaptureOnSelection()) {
            this.setUpdateCaptureOnSelection(false);
            Range range = this.getTimeline().getSelectionRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"timeline.selectionRange");
            this.doSelectCaptureDuration(this.getIntersectingCaptureDuration(range), SwingUtilities::invokeLater);
            this.setUpdateCaptureOnSelection(true);
        }
    }

    @Override
    protected void onCaptureToSelect(@NotNull SeriesData<CaptureDurationData<? extends CaptureObject>> captureToSelect, @NotNull Executor loadJoiner) {
        Intrinsics.checkNotNullParameter(captureToSelect, (String)"captureToSelect");
        Intrinsics.checkNotNullParameter((Object)loadJoiner, (String)"loadJoiner");
        this.doSelectCaptureDuration((CaptureDurationData)((Object)captureToSelect.value), loadJoiner);
    }

    public final void selectAll() {
        this.getTimeline().getSelectionRange().set(this.minTrackingTimeUs, Math.min(this.maxTrackingTimeUs, this.getTimeline().getDataRange().getMax()));
    }

    public final boolean isAlmostAllSelected() {
        return AllocationStage.isAlmostAllSelected$almostEqual(this.getTimeline().getSelectionRange().getMin(), this.minTrackingTimeUs) && AllocationStage.isAlmostAllSelected$almostEqual(this.getTimeline().getSelectionRange().getMax(), Math.min(this.maxTrackingTimeUs, this.getTimeline().getDataRange().getMax()));
    }

    @Override
    public void enter() {
        this.logEnterStage();
        super.enter();
        if (this.isStatic()) {
            this.getTimeline().getViewRange().set(this.minTrackingTimeUs, this.maxTrackingTimeUs);
            this.getTimeline().getSelectionRange().set(this.minTrackingTimeUs, this.maxTrackingTimeUs);
        } else {
            Range range;
            this.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_STATUS, () -> AllocationStage.enter$lambda$0(this));
            this.setupTrackingEventListener();
            StudioProfilers studioProfilers = this.getStudioProfilers();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"studioProfilers");
            MemoryProfiler.Companion.trackAllocations(studioProfilers, this.getSessionData(), true, null);
            Range $this$enter_u24lambda_u242 = range = this.getTimeline().getSelectionRange();
            boolean bl = false;
            $this$enter_u24lambda_u242.addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> AllocationStage.enter$lambda$2$lambda$1(this, $this$enter_u24lambda_u242));
        }
    }

    @Override
    public void exit() {
        super.exit();
        this.stopTracking();
        this.getTimeline().getSelectionRange().removeDependencies((AspectObserver)this);
    }

    @VisibleForTesting
    public final void startLiveDataTimeline() {
        boolean bl;
        boolean bl2 = bl = this.getLiveAllocationSamplingMode() != BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.NONE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !this.lastTrackingEvent.getIsEnded();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.minTrackingTimeUs = TimeUnit.NANOSECONDS.toMicros(this.lastTrackingEvent.getTimestamp() + (long)1000);
        this.getTimeline().getSelectionRange().set(this.minTrackingTimeUs, this.minTrackingTimeUs);
        this.getTimeline().getViewRange().set(this.minTrackingTimeUs, this.minTrackingTimeUs);
        this.getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::onNewData);
    }

    public final void stopTracking() {
        if (!this.getHasEndedTracking()) {
            this.getAspect().removeDependencies((AspectObserver)this);
            this.getTimeline().getDataRange().removeDependencies((AspectObserver)this);
            this.maxTrackingTimeUs = this.getTimeline().getDataRange().getMax();
        }
        StudioProfilers studioProfilers = this.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"studioProfilers");
        MemoryProfiler.Companion.trackAllocations(studioProfilers, this.getSessionData(), false, null);
    }

    private final void onNewData() {
        boolean bl;
        StreamingTimeline $this$onNewData_u24lambda_u243 = this.getTimeline();
        boolean bl2 = false;
        boolean bl3 = bl = !this.getHasEndedTracking();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        double dataMax = $this$onNewData_u24lambda_u243.getDataRange().getMax();
        if (dataMax >= $this$onNewData_u24lambda_u243.getViewRange().getMax()) {
            double initialSessionLengthUs = TimeUnit.SECONDS.toMicros(15L);
            double length = Math.max((double)2 * (dataMax - this.minTrackingTimeUs), initialSessionLengthUs);
            $this$onNewData_u24lambda_u243.getViewRange().set(this.minTrackingTimeUs, this.minTrackingTimeUs + length);
        } else if (Random.Default.nextBoolean()) {
            Range range = $this$onNewData_u24lambda_u243.getViewRange();
            double d = range.getMax();
            range.setMax(d + 1.0);
        } else {
            Range range = $this$onNewData_u24lambda_u243.getViewRange();
            double d = range.getMax();
            range.setMax(d + -1.0);
        }
        if ($this$onNewData_u24lambda_u243.getSelectionRange().getMin() == this.minTrackingTimeUs || $this$onNewData_u24lambda_u243.getSelectionRange().isEmpty()) {
            $this$onNewData_u24lambda_u243.getSelectionRange().set(this.minTrackingTimeUs, dataMax);
        }
    }

    @Override
    @NotNull
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.MEMORY_JVM_RECORDING_STAGE;
    }

    private static final boolean isAlmostAllSelected$almostEqual(double $this$isAlmostAllSelected_u24almostEqual, double that) {
        return Math.abs($this$isAlmostAllSelected_u24almostEqual - that) <= 0.001;
    }

    private static final void enter$lambda$0(AllocationStage this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.getHasStartedTracking()) {
            this$0.getAspect().removeDependencies((AspectObserver)this$0);
        } else {
            this$0.startLiveDataTimeline();
        }
    }

    private static final void enter$lambda$2$lambda$1(AllocationStage this$0, Range $this_apply) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        double rightBound = Math.min(this$0.getTimeline().getDataRange().getMax(), this$0.maxTrackingTimeUs);
        if (!$this_apply.isEmpty() && $this_apply.getMin() > rightBound) {
            this$0.selectAll();
        } else if ($this_apply.getMax() > rightBound) {
            $this_apply.setMax(rightBound);
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        return Companion.makeLiveStage(profilers, loader);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader, double minTrackingTimeUs, double maxTrackingTimeUs) {
        return Companion.makeStaticStage(profilers, loader, minTrackingTimeUs, maxTrackingTimeUs);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers) {
        return Companion.makeLiveStage(profilers);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, double minTrackingTimeUs, double maxTrackingTimeUs) {
        return Companion.makeStaticStage(profilers, minTrackingTimeUs, maxTrackingTimeUs);
    }

    public static final /* synthetic */ void access$setLastTrackingEvent$p(AllocationStage $this, Common.Event event) {
        $this.lastTrackingEvent = event;
    }

    public /* synthetic */ AllocationStage(StudioProfilers profilers, CaptureObjectLoader loader, double initMinUs, double initMaxUs, DefaultConstructorMarker $constructor_marker) {
        this(profilers, loader, initMinUs, initMaxUs);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J*\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/AllocationStage$Companion;", "", "()V", "makeLiveStage", "Lcom/android/tools/profilers/memory/AllocationStage;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "loader", "Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "makeStaticStage", "minTrackingTimeUs", "", "maxTrackingTimeUs", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            return new AllocationStage(profilers, loader, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null);
        }

        public static /* synthetic */ AllocationStage makeLiveStage$default(Companion companion, StudioProfilers studioProfilers, CaptureObjectLoader captureObjectLoader, int n, Object object) {
            if ((n & 2) != 0) {
                captureObjectLoader = new CaptureObjectLoader();
            }
            return companion.makeLiveStage(studioProfilers, captureObjectLoader);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader, double minTrackingTimeUs, double maxTrackingTimeUs) {
            AllocationStage allocationStage;
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            AllocationStage it = allocationStage = new AllocationStage(profilers, loader, minTrackingTimeUs, maxTrackingTimeUs, null);
            boolean bl = false;
            double d = minTrackingTimeUs;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            d = maxTrackingTimeUs;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(minTrackingTimeUs <= maxTrackingTimeUs)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return allocationStage;
        }

        public static /* synthetic */ AllocationStage makeStaticStage$default(Companion companion, StudioProfilers studioProfilers, CaptureObjectLoader captureObjectLoader, double d, double d2, int n, Object object) {
            if ((n & 2) != 0) {
                captureObjectLoader = new CaptureObjectLoader();
            }
            return companion.makeStaticStage(studioProfilers, captureObjectLoader, d, d2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            return com.android.tools.profilers.memory.AllocationStage$Companion.makeLiveStage$default(this, profilers, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, double minTrackingTimeUs, double maxTrackingTimeUs) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            return com.android.tools.profilers.memory.AllocationStage$Companion.makeStaticStage$default(this, profilers, null, minTrackingTimeUs, maxTrackingTimeUs, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

