/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureObjectLoader {
    @Nullable
    private ExecutorService myExecutorService = null;
    @Nullable
    private ListenableFutureTask<CaptureObject> myOutstandingLoadingTask = null;

    @NotNull
    public ListenableFuture<CaptureObject> loadCapture(@NotNull CaptureObject captureObject, @Nullable Range queryRange, @Nullable Executor queryJoiner) {
        ListenableFutureTask task;
        if (captureObject == null) {
            CaptureObjectLoader.$$$reportNull$$$0(0);
        }
        assert (this.myExecutorService != null);
        this.cancelTask();
        this.myOutstandingLoadingTask = task = ListenableFutureTask.create(() -> captureObject.load(queryRange, queryJoiner) ? captureObject : null);
        Futures.addCallback((ListenableFuture)task, (FutureCallback)new FutureCallback<CaptureObject>(){

            public void onSuccess(@Nullable CaptureObject result) {
                this.removeTask();
            }

            public void onFailure(@NotNull Throwable ignored) {
                if (ignored == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.removeTask();
            }

            private void removeTask() {
                CaptureObjectLoader.this.myOutstandingLoadingTask = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/android/tools/profilers/memory/CaptureObjectLoader$1", "onFailure"));
            }
        }, (Executor)MoreExecutors.directExecutor());
        this.myExecutorService.execute((Runnable)task);
        ListenableFutureTask listenableFutureTask = task;
        if (listenableFutureTask == null) {
            CaptureObjectLoader.$$$reportNull$$$0(1);
        }
        return listenableFutureTask;
    }

    public void start() {
        if (this.myExecutorService == null) {
            this.myExecutorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("profiler-capture-object-loader").build());
        }
    }

    public void stop() {
        this.cancelTask();
        if (this.myExecutorService != null) {
            this.myExecutorService.shutdownNow();
            this.myExecutorService = null;
        }
    }

    private void cancelTask() {
        if (this.myOutstandingLoadingTask != null) {
            this.myOutstandingLoadingTask.cancel(true);
            this.myOutstandingLoadingTask = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/CaptureObjectLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/CaptureObjectLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCapture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCapture";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

