/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.memory.CsvExporter;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB3\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJj\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00150\u00032\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00190\u00172\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u0002H\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00010\u00170\u001bH\u0007J\u0006\u0010\u001c\u001a\u00020\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/profilers/memory/CsvExporter;", "", "getTree", "Lkotlin/Function0;", "Ljavax/swing/JTree;", "getCaptureObject", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "ideProfilerComponents", "Lcom/android/tools/profilers/IdeProfilerComponents;", "ideServices", "Lcom/android/tools/profilers/IdeProfilerServices;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/android/tools/profilers/IdeProfilerComponents;Lcom/android/tools/profilers/IdeProfilerServices;)V", "makeClassExportItem", "Lcom/android/tools/adtui/stdui/ContextMenuItem;", "makeContextMenuItem", "Lcom/android/tools/profilers/memory/CsvExporter$RunnableContextMenuItem;", "E", "A", "title", "", "getAttributes", "", "getEntryStream", "Lkotlin/Function1;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "Ljava/util/stream/Stream;", "formatters", "", "makeInstanceExportItem", "RunnableContextMenuItem", "intellij.android.profilers.ui"})
public final class CsvExporter {
    @NotNull
    private final Function0<JTree> getTree;
    @NotNull
    private final Function0<CaptureObject> getCaptureObject;
    @NotNull
    private final IdeProfilerComponents ideProfilerComponents;
    @NotNull
    private final IdeProfilerServices ideServices;

    public CsvExporter(@NotNull Function0<? extends JTree> getTree, @NotNull Function0<? extends CaptureObject> getCaptureObject, @NotNull IdeProfilerComponents ideProfilerComponents, @NotNull IdeProfilerServices ideServices) {
        Intrinsics.checkNotNullParameter(getTree, (String)"getTree");
        Intrinsics.checkNotNullParameter(getCaptureObject, (String)"getCaptureObject");
        Intrinsics.checkNotNullParameter((Object)ideProfilerComponents, (String)"ideProfilerComponents");
        Intrinsics.checkNotNullParameter((Object)ideServices, (String)"ideServices");
        this.getTree = getTree;
        this.getCaptureObject = getCaptureObject;
        this.ideProfilerComponents = ideProfilerComponents;
        this.ideServices = ideServices;
    }

    @NotNull
    public final ContextMenuItem makeClassExportItem() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)makeClassExportItem.3.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)makeClassExportItem.4.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)makeClassExportItem.5.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.TOTAL_COUNT), (Object)((Object)makeClassExportItem.6.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.NATIVE_SIZE), (Object)((Object)makeClassExportItem.7.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE), (Object)((Object)makeClassExportItem.8.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_DIFFERENCE), (Object)((Object)makeClassExportItem.9.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.RETAINED_SIZE), (Object)((Object)makeClassExportItem.10.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS_SIZE), (Object)((Object)makeClassExportItem.11.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS_SIZE), (Object)((Object)makeClassExportItem.12.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.ClassifierAttribute.REMAINING_SIZE), (Object)((Object)makeClassExportItem.13.INSTANCE))};
        return this.makeContextMenuItem("Export class entries under selection", (Function0)new Function0<List<? extends CaptureObject.ClassifierAttribute>>(this){
            final /* synthetic */ CsvExporter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<CaptureObject.ClassifierAttribute> invoke() {
                List<CaptureObject.ClassifierAttribute> list = ((CaptureObject)CsvExporter.access$getGetCaptureObject$p(this.this$0).invoke()).getClassifierAttributes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCaptureObject().classifierAttributes");
                return list;
            }
        }, makeClassExportItem.2.INSTANCE, MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public final RunnableContextMenuItem makeInstanceExportItem() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CaptureObject.InstanceAttribute.LABEL), (Object)((Object)makeInstanceExportItem.3.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.InstanceAttribute.DEPTH), (Object)((Object)makeInstanceExportItem.4.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.InstanceAttribute.ALLOCATION_TIME), (Object)((Object)makeInstanceExportItem.5.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.InstanceAttribute.DEALLOCATION_TIME), (Object)((Object)makeInstanceExportItem.6.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.InstanceAttribute.NATIVE_SIZE), (Object)((Object)makeInstanceExportItem.7.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.InstanceAttribute.SHALLOW_SIZE), (Object)((Object)makeInstanceExportItem.8.INSTANCE)), TuplesKt.to((Object)((Object)CaptureObject.InstanceAttribute.RETAINED_SIZE), (Object)((Object)makeInstanceExportItem.9.INSTANCE))};
        return this.makeContextMenuItem("Export instance entries under selection", (Function0)new Function0<List<? extends CaptureObject.InstanceAttribute>>(this){
            final /* synthetic */ CsvExporter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<CaptureObject.InstanceAttribute> invoke() {
                List<CaptureObject.InstanceAttribute> list = ((CaptureObject)CsvExporter.access$getGetCaptureObject$p(this.this$0).invoke()).getInstanceAttributes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCaptureObject().instanceAttributes");
                return list;
            }
        }, makeInstanceExportItem.2.INSTANCE, MapsKt.mapOf((Pair[])pairArray));
    }

    @VisibleForTesting
    @NotNull
    public final <E, A> RunnableContextMenuItem makeContextMenuItem(@NotNull String title, @NotNull Function0<? extends List<? extends A>> getAttributes, @NotNull Function1<? super ClassifierSet, ? extends Stream<E>> getEntryStream, @NotNull Map<A, ? extends Function1<? super E, ? extends Object>> formatters) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(getAttributes, (String)"getAttributes");
        Intrinsics.checkNotNullParameter(getEntryStream, (String)"getEntryStream");
        Intrinsics.checkNotNullParameter(formatters, (String)"formatters");
        return new RunnableContextMenuItem(title, this, getAttributes, getEntryStream, formatters){
            final /* synthetic */ String $title;
            final /* synthetic */ CsvExporter this$0;
            final /* synthetic */ Function0<List<A>> $getAttributes;
            final /* synthetic */ Function1<ClassifierSet, Stream<E>> $getEntryStream;
            final /* synthetic */ Map<A, Function1<E, Object>> $formatters;
            {
                this.$title = $title;
                this.this$0 = $receiver;
                this.$getAttributes = $getAttributes;
                this.$getEntryStream = $getEntryStream;
                this.$formatters = $formatters;
            }

            @NotNull
            public String getText() {
                return this.$title;
            }

            @Nullable
            public Void getIcon() {
                return null;
            }

            public boolean isEnabled() {
                boolean bl;
                JTree jTree = (JTree)CsvExporter.access$getGetTree$p(this.this$0).invoke();
                if (jTree != null) {
                    JTree it = jTree;
                    boolean bl2 = false;
                    bl = !it.isSelectionEmpty();
                } else {
                    bl = false;
                }
                return bl;
            }

            public void run() {
                CsvExporter.access$getIdeProfilerComponents$p(this.this$0).createExportDialog().open(makeContextMenuItem.1::run$lambda$1, MemoryProfiler.Companion::generateCaptureFileName, makeContextMenuItem.1::run$lambda$2, arg_0 -> makeContextMenuItem.1.run$lambda$3(this.this$0, this, arg_0));
            }

            public void exportEntries(@NotNull OutputStream output) {
                block1: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
                    Object object = (JTree)CsvExporter.access$getGetTree$p(this.this$0).invoke();
                    if (object == null || (object = ((JTree)object).getSelectionPath()) == null || (object = ((TreePath)object).getLastPathComponent()) == null) break block1;
                    Object object2 = object;
                    Function0<List<A>> function0 = this.$getAttributes;
                    Function1<ClassifierSet, Stream<E>> function1 = this.$getEntryStream;
                    Map<A, Function1<E, Object>> map = this.$formatters;
                    Object selection = object2;
                    boolean bl2 = false;
                    List $this$exportEntries_u24lambda_u247_u24lambda_u244 = (List)function0.invoke();
                    boolean bl3 = false;
                    boolean bl4 = bl = !((Collection)$this$exportEntries_u24lambda_u247_u24lambda_u244).isEmpty();
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    Pair pair = new Pair($this$exportEntries_u24lambda_u247_u24lambda_u244.subList(0, $this$exportEntries_u24lambda_u247_u24lambda_u244.size() - 1), CollectionsKt.last((List)$this$exportEntries_u24lambda_u247_u24lambda_u244));
                    List initAttrs = (List)pair.component1();
                    Object lastAttr = pair.component2();
                    makeContextMenuItem.1.exportEntries$lambda$7$outputLine(initAttrs, writer, lastAttr, makeContextMenuItem.exportEntries.1.2.INSTANCE);
                    T t = ((MemoryObjectTreeNode)selection).getAdapter();
                    Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet");
                    ((Stream)function1.invoke((Object)((ClassifierSet)t))).forEach(arg_0 -> makeContextMenuItem.1.exportEntries$lambda$7$lambda$6((Function1)new Function1<E, Unit>(map, initAttrs, writer, lastAttr){
                        final /* synthetic */ Map<A, Function1<E, Object>> $formatters;
                        final /* synthetic */ List<A> $initAttrs;
                        final /* synthetic */ BufferedWriter $writer;
                        final /* synthetic */ A $lastAttr;
                        {
                            this.$formatters = $formatters;
                            this.$initAttrs = $initAttrs;
                            this.$writer = $writer;
                            this.$lastAttr = $lastAttr;
                            super(1);
                        }

                        public final void invoke(E inst) {
                            makeContextMenuItem.1.access$exportEntries$lambda$7$outputLine(this.$initAttrs, this.$writer, this.$lastAttr, (Function1)new Function1<A, Object>(this.$formatters, inst){
                                final /* synthetic */ Map<A, Function1<E, Object>> $formatters;
                                final /* synthetic */ E $inst;
                                {
                                    this.$formatters = $formatters;
                                    this.$inst = $inst;
                                    super(1);
                                }

                                @NotNull
                                public final Object invoke(A it) {
                                    Function1<E, Object> function1 = this.$formatters.get(it);
                                    Intrinsics.checkNotNull(function1);
                                    return function1.invoke(this.$inst);
                                }
                            });
                        }
                    }, arg_0));
                    writer.flush();
                }
            }

            private static final String run$lambda$1() {
                return "Export As";
            }

            private static final String run$lambda$2() {
                return "csv";
            }

            private static final void run$lambda$3(CsvExporter this$0, makeContextMenuItem.1 this$1, File it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                IdeProfilerServices ideProfilerServices = CsvExporter.access$getIdeServices$p(this$0);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ideProfilerServices.saveFile(it, this$1::exportEntries, null);
            }

            private static final <A> void exportEntries$lambda$7$outputLine(List<? extends A> initAttrs, BufferedWriter writer, A lastAttr, Function1<? super A, ? extends Object> onAttr) {
                Iterable $this$forEach$iv = initAttrs;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    writer.write(onAttr.invoke(it).toString());
                    writer.write(",");
                }
                writer.write(onAttr.invoke(lastAttr).toString());
                writer.newLine();
            }

            private static final void exportEntries$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            public static final /* synthetic */ void access$exportEntries$lambda$7$outputLine(List initAttrs, BufferedWriter writer, Object lastAttr, Function1 onAttr) {
                makeContextMenuItem.1.exportEntries$lambda$7$outputLine(initAttrs, writer, lastAttr, onAttr);
            }
        };
    }

    private static final Stream makeClassExportItem$classStream$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Stream<ClassSet> makeClassExportItem$classStream(ClassifierSet c) {
        Stream<ClassifierSet> stream;
        if (c instanceof ClassSet) {
            Stream<ClassifierSet> stream2 = Stream.of(c);
            stream = stream2;
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"of(c)");
        } else {
            Stream stream3 = c.getChildrenClassifierSets().stream().flatMap(arg_0 -> CsvExporter.makeClassExportItem$classStream$lambda$0(makeClassExportItem.classStream.1.INSTANCE, arg_0));
            stream = stream3;
            Intrinsics.checkNotNullExpressionValue(stream3, (String)"c.childrenClassifierSets\u2026().flatMap(::classStream)");
        }
        return stream;
    }

    public static final /* synthetic */ Function0 access$getGetCaptureObject$p(CsvExporter $this) {
        return $this.getCaptureObject;
    }

    public static final /* synthetic */ Stream access$makeClassExportItem$classStream(ClassifierSet c) {
        return CsvExporter.makeClassExportItem$classStream(c);
    }

    public static final /* synthetic */ Function0 access$getGetTree$p(CsvExporter $this) {
        return $this.getTree;
    }

    public static final /* synthetic */ IdeProfilerComponents access$getIdeProfilerComponents$p(CsvExporter $this) {
        return $this.ideProfilerComponents;
    }

    public static final /* synthetic */ IdeProfilerServices access$getIdeServices$p(CsvExporter $this) {
        return $this.ideServices;
    }

    @VisibleForTesting
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/android/tools/profilers/memory/CsvExporter$RunnableContextMenuItem;", "Lcom/android/tools/adtui/stdui/ContextMenuItem;", "exportEntries", "", "out", "Ljava/io/OutputStream;", "intellij.android.profilers.ui"})
    public static interface RunnableContextMenuItem
    extends ContextMenuItem {
        public void exportEntries(@NotNull OutputStream var1);
    }
}

