/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryCaptureView
extends AspectObserver {
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private final JLabel myLabel;
    @NotNull
    private final JPanel myPanel;
    @Nullable
    private CaptureObject myCaptureObject;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryCaptureView.class);
    }

    MemoryCaptureView(@NotNull MemoryCaptureSelection selection, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (selection == null) {
            MemoryCaptureView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            MemoryCaptureView.$$$reportNull$$$0(1);
        }
        this.myCaptureObject = null;
        this.mySelection = selection;
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADING_CAPTURE, this::reset).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::refresh);
        this.myPanel = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myLabel = new JLabel();
        this.myLabel.setBorder((Border)new JBEmptyBorder(0, 11, 0, 3));
        this.reset();
    }

    @VisibleForTesting
    @NotNull
    JLabel getLabel() {
        JLabel jLabel = this.myLabel;
        if (jLabel == null) {
            MemoryCaptureView.$$$reportNull$$$0(2);
        }
        return jLabel;
    }

    @NotNull
    JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            MemoryCaptureView.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void reset() {
        this.myPanel.removeAll();
        this.myLabel.setText("");
        this.myCaptureObject = this.mySelection.getSelectedCapture();
    }

    private void refresh() {
        boolean validCapture;
        CaptureObject captureObject = this.mySelection.getSelectedCapture();
        boolean bl = validCapture = captureObject == this.myCaptureObject && this.myCaptureObject != null;
        if (validCapture) {
            this.myLabel.setText(this.myCaptureObject.getName());
            this.myPanel.add(this.myLabel);
            this.myPanel.add((Component)new FlatSeparator());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryCaptureView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryCaptureView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

