/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryMonitorTooltip;
import com.android.tools.profilers.memory.MemoryUsage;
import org.jetbrains.annotations.NotNull;

public class MemoryMonitor
extends ProfilerMonitor {
    @NotNull
    private final ClampedAxisComponentModel myMemoryAxis;
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = new MemoryAxisFormatter(1, 2, 5);
    private final MemoryUsage myMemoryUsage;
    private final MemoryLegend myMemoryLegend;
    private MemoryLegend myTooltipLegend;

    public MemoryMonitor(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryMonitor.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myMemoryUsage = new MemoryUsage(profilers);
        this.myMemoryAxis = new ClampedAxisComponentModel.Builder(this.myMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER).build();
        this.myMemoryLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getDataRange());
        this.myTooltipLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getTooltipRange());
    }

    @Override
    public String getName() {
        return "MEMORY";
    }

    @Override
    public TooltipModel buildTooltip() {
        return new MemoryMonitorTooltip(this);
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryAxis);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryAxis);
        this.myProfilers.removeDependencies((AspectObserver)this);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new MainMemoryProfilerStage(this.myProfilers));
    }

    @NotNull
    public AxisComponentModel getMemoryAxis() {
        ClampedAxisComponentModel clampedAxisComponentModel = this.myMemoryAxis;
        if (clampedAxisComponentModel == null) {
            MemoryMonitor.$$$reportNull$$$0(1);
        }
        return clampedAxisComponentModel;
    }

    public MemoryUsage getMemoryUsage() {
        return this.myMemoryUsage;
    }

    public MemoryLegend getMemoryLegend() {
        return this.myMemoryLegend;
    }

    public MemoryLegend getTooltipLegend() {
        return this.myTooltipLegend;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryAxis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class MemoryLegend
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myTotalLegend;

        public MemoryLegend(@NotNull MemoryUsage usage, @NotNull Range range) {
            if (usage == null) {
                MemoryLegend.$$$reportNull$$$0(0);
            }
            if (range == null) {
                MemoryLegend.$$$reportNull$$$0(1);
            }
            super(range);
            this.myTotalLegend = new SeriesLegend(usage.getTotalMemorySeries(), MEMORY_AXIS_FORMATTER, range);
            this.add((Legend)this.myTotalLegend);
        }

        @NotNull
        public Legend getTotalLegend() {
            SeriesLegend seriesLegend = this.myTotalLegend;
            if (seriesLegend == null) {
                MemoryLegend.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/MemoryMonitor$MemoryLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/MemoryMonitor$MemoryLegend";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTotalLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

