/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerKt;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J6\u0010\"\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142$\u0010#\u001a \u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110$H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/android/tools/profilers/memory/MemoryProfiler;", "Lcom/android/tools/profilers/StudioProfiler;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "(Lcom/android/tools/profilers/StudioProfilers;)V", "featureTracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "getFeatureTracker", "()Lcom/android/tools/profilers/analytics/FeatureTracker;", "myAspectObserver", "Lcom/android/tools/adtui/model/AspectObserver;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "Lorg/jetbrains/annotations/NotNull;", "getSessionsManager", "()Lcom/android/tools/profilers/sessions/SessionsManager;", "agentStatusChanged", "", "import", "file", "Ljava/io/File;", "makeEvent", "Lkotlin/Function2;", "", "Lcom/android/tools/profiler/proto/Common$Event;", "importHeapprofd", "importHprof", "importLegacyAllocations", "newMonitor", "Lcom/android/tools/profilers/memory/MemoryMonitor;", "startProfiling", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "stopProfiling", "withFileImportedOnce", "handle", "Lkotlin/Function4;", "", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nMemoryProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryProfiler.kt\ncom/android/tools/profilers/memory/MemoryProfiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
public final class MemoryProfiler
implements StudioProfiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final AspectObserver myAspectObserver;

    public MemoryProfiler(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        this.profilers = profilers;
        this.myAspectObserver = new AspectObserver();
        this.profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.getSessionsManager().registerImportHandler("hprof", this::importHprof);
        this.getSessionsManager().registerImportHandler("alloc", this::importLegacyAllocations);
        this.getSessionsManager().registerImportHandler("heapprofd", this::importHeapprofd);
        this.profilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, () -> MemoryProfiler._init_$lambda$1(this));
    }

    private final SessionsManager getSessionsManager() {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sessionsManager), (String)"profilers.sessionsManager");
        return sessionsManager;
    }

    private final FeatureTracker getFeatureTracker() {
        return this.profilers.getIdeServices().getFeatureTracker();
    }

    @Override
    @NotNull
    public MemoryMonitor newMonitor() {
        return new MemoryMonitor(this.profilers);
    }

    @Override
    public void startProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
    }

    @Override
    public void stopProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        try {
            Companion.trackAllocations(this.profilers, session, false, null);
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.Companion.getLogger().info((Throwable)e);
        }
    }

    private final void agentStatusChanged() {
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"profilers.session");
        Common.Session session2 = session;
        if (!Intrinsics.areEqual((Object)Common.Session.getDefaultInstance(), (Object)session2) && session2.getEndTimestamp() == Long.MAX_VALUE && this.profilers.isAgentAttached()) {
            try {
                Companion.trackAllocations(this.profilers, session2, false, null);
            }
            catch (StatusRuntimeException e) {
                MemoryProfiler.Companion.getLogger().info((Throwable)e);
            }
        }
    }

    private final void importHprof(File file) {
        this.import(file, (Function2<? super Long, ? super Long, Common.Event>)((Function2)importHprof.1.INSTANCE));
        this.getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private final void importHeapprofd(File file) {
        this.import(file, (Function2<? super Long, ? super Long, Common.Event>)((Function2)importHeapprofd.1.INSTANCE));
    }

    private final void importLegacyAllocations(File file) {
        this.import(file, (Function2<? super Long, ? super Long, Common.Event>)((Function2)importLegacyAllocations.1.INSTANCE));
        this.getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private final void import(File file, Function2<? super Long, ? super Long, Common.Event> makeEvent) {
        this.withFileImportedOnce(file, (Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit>)((Function4)new Function4<byte[], Long, Long, Long, Unit>(this, file, makeEvent){
            final /* synthetic */ MemoryProfiler this$0;
            final /* synthetic */ File $file;
            final /* synthetic */ Function2<Long, Long, Common.Event> $makeEvent;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$makeEvent = $makeEvent;
                super(4);
            }

            public final void invoke(@NotNull byte[] bytes, long startTimestampsEpochMs, long startTime, long endTime) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                Common.Event[] eventArray = new Common.Event[]{this.$makeEvent.invoke((Object)startTime, (Object)endTime)};
                MemoryProfiler.access$getSessionsManager(this.this$0).createImportedSession(this.$file.getName(), Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)ByteString.copyFrom((byte[])bytes))), eventArray);
            }
        }));
    }

    private final void withFileImportedOnce(File file, Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit> handle) {
        block3: {
            byte[] byArray;
            long startTimestampEpochNs = System.currentTimeMillis();
            com.intellij.openapi.util.Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
            Long sessionStartTimeNs = (Long)timestampsNs.first;
            Long sessionEndTimeNs = (Long)timestampsNs.second;
            SessionsManager sessionsManager = this.getSessionsManager();
            Intrinsics.checkNotNullExpressionValue((Object)sessionStartTimeNs, (String)"sessionStartTimeNs");
            if (sessionsManager.setSessionById(sessionStartTimeNs)) break block3;
            try {
                byArray = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            }
            catch (IOException e) {
                MemoryProfiler.Companion.getLogger().error("Importing Session Failed: cannot read from " + file.getPath());
                byArray = null;
            }
            byte[] byArray2 = byArray;
            if (byArray2 != null) {
                byte[] bytes = byArray2;
                boolean bl = false;
                Long l = startTimestampEpochNs;
                Intrinsics.checkNotNullExpressionValue((Object)sessionEndTimeNs, (String)"sessionEndTimeNs");
                handle.invoke((Object)bytes, (Object)l, (Object)sessionStartTimeNs, (Object)sessionEndTimeNs);
            }
        }
    }

    private static final void _init_$lambda$1(MemoryProfiler this$0) {
        StreamingTimeline streamingTimeline;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MainMemoryProfilerStage stage = new MainMemoryProfilerStage(this$0.profilers);
        this$0.profilers.setStage(stage);
        stage.setPendingCaptureStartTimeGuarded(this$0.profilers.getSession().getStartTimestamp());
        StreamingTimeline $this$lambda_u241_u24lambda_u240 = streamingTimeline = this$0.profilers.getTimeline();
        boolean bl = false;
        $this$lambda_u241_u24lambda_u240.reset(this$0.profilers.getSession().getStartTimestamp(), this$0.profilers.getSession().getEndTimestamp());
        $this$lambda_u241_u24lambda_u240.getViewRange().set($this$lambda_u241_u24lambda_u240.getDataRange());
        $this$lambda_u241_u24lambda_u240.setIsPaused(true);
    }

    private static final Memory.HeapDumpInfo.Builder importHprof$makeInfo(long start, long end) {
        return Memory.HeapDumpInfo.newBuilder().setStartTime(start).setEndTime(end);
    }

    private static final Memory.AllocationsInfo.Builder importLegacyAllocations$makeInfo$2(long start, long end) {
        return Memory.AllocationsInfo.newBuilder().setStartTime(start).setEndTime(end).setLegacy(true).setSuccess(true);
    }

    @JvmStatic
    public static final boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        return Companion.isUsingLiveAllocation(profilers, session);
    }

    @JvmStatic
    public static final boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull StudioProfilers profilers, @NotNull Common.Session session, long startTimeUs, long endTimeUs) {
        return Companion.hasOnlyFullAllocationTrackingWithinRegion(profilers, session, startTimeUs, endTimeUs);
    }

    @JvmStatic
    public static final void saveHeapDumpToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Companion.saveHeapDumpToFile(client, session, info, outputStream, featureTracker);
    }

    @JvmStatic
    public static final void saveLegacyAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Companion.saveLegacyAllocationToFile(client, session, info, outputStream, featureTracker);
    }

    @JvmStatic
    public static final void saveHeapProfdSampleToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Trace.TraceInfo info, @NotNull OutputStream outputStream) {
        Companion.saveHeapProfdSampleToFile(client, session, info, outputStream);
    }

    @JvmStatic
    @NotNull
    public static final String generateCaptureFileName() {
        return Companion.generateCaptureFileName();
    }

    @JvmStatic
    @NotNull
    public static final List<Trace.TraceInfo> getNativeHeapSamplesForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getNativeHeapSamplesForSession(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Common.Event> getNativeHeapEventsForSessionSortedByTimestamp(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getNativeHeapEventsForSessionSortedByTimestamp(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.HeapDumpInfo> getHeapDumpsForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getHeapDumpsForSession(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.AllocationsInfo> getAllocationInfosForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getAllocationInfosForSession(client, session, rangeUs);
    }

    @JvmStatic
    public static final void trackAllocations(@NotNull StudioProfilers profilers, @NotNull Common.Session session, boolean enable, @Nullable Consumer<Memory.TrackStatus> responseHandler) {
        Companion.trackAllocations(profilers, session, enable, responseHandler);
    }

    public static final /* synthetic */ Memory.HeapDumpInfo.Builder access$importHprof$makeInfo(long start, long end) {
        return MemoryProfiler.importHprof$makeInfo(start, end);
    }

    public static final /* synthetic */ Memory.AllocationsInfo.Builder access$importLegacyAllocations$makeInfo$2(long start, long end) {
        return MemoryProfiler.importLegacyAllocations$makeInfo$2(start, end);
    }

    public static final /* synthetic */ SessionsManager access$getSessionsManager(MemoryProfiler $this) {
        return $this.getSessionsManager();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007JH\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\n\"\u0004\b\u0000\u0010\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001f0\u001f0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0007J\u0018\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J0\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0007J(\u0010/\u001a\u00020)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0007J0\u00100\u001a\u00020)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0007J>\u00101\u001a\u00020)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00102\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\f\u00103\u001a\b\u0012\u0004\u0012\u00020)042\u0006\u00105\u001a\u00020\bH\u0002J2\u00106\u001a\u00020)2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00107\u001a\u00020!2\u0010\u00108\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010:\u0018\u000109H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006;"}, d2={"Lcom/android/tools/profilers/memory/MemoryProfiler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "generateCaptureFileName", "", "getAllocationInfosForSession", "", "Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "client", "Lcom/android/tools/profilers/ProfilerClient;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "rangeUs", "Lcom/android/tools/adtui/model/Range;", "getForSession", "T", "eventKind", "Lcom/android/tools/profiler/proto/Common$Event$Kind;", "mapper", "Lkotlin/Function1;", "Lcom/android/tools/profiler/proto/Transport$EventGroup;", "getHeapDumpsForSession", "Lcom/android/tools/profiler/proto/Memory$HeapDumpInfo;", "getNativeHeapEventsForSessionSortedByTimestamp", "Lcom/android/tools/profiler/proto/Common$Event;", "kotlin.jvm.PlatformType", "getNativeHeapSamplesForSession", "Lcom/android/tools/profiler/proto/Trace$TraceInfo;", "hasOnlyFullAllocationTrackingWithinRegion", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "startTimeUs", "", "endTimeUs", "isUsingLiveAllocation", "saveHeapDumpToFile", "", "info", "outputStream", "Ljava/io/OutputStream;", "featureTracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "saveHeapProfdSampleToFile", "saveLegacyAllocationToFile", "saveToFile", "startTime", "onFinished", "Lkotlin/Function0;", "errorMsg", "trackAllocations", "enable", "responseHandler", "Ljava/util/function/Consumer;", "Lcom/android/tools/profiler/proto/Memory$TrackStatus;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nMemoryProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryProfiler.kt\ncom/android/tools/profilers/memory/MemoryProfiler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1#2:327\n1549#3:328\n1620#3,3:329\n*S KotlinDebug\n*F\n+ 1 MemoryProfiler.kt\ncom/android/tools/profilers/memory/MemoryProfiler$Companion\n*L\n275#1:328\n275#1:329,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance(MemoryProfiler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(MemoryProfiler::class.java)");
            return logger;
        }

        @JvmStatic
        public final boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ProfilerClient profilerClient = profilers.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"profilers.client");
            Range range = profilers.getTimeline().getDataRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"profilers.timeline.dataRange");
            List<Memory.AllocationsInfo> it = this.getAllocationInfosForSession(profilerClient, session, range);
            boolean bl = false;
            return !((Collection)it).isEmpty() && !it.get(0).getLegacy();
        }

        @JvmStatic
        public final boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull StudioProfilers profilers, @NotNull Common.Session session, long startTimeUs, long endTimeUs) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            AllocationSamplingRateDataSeries series = new AllocationSamplingRateDataSeries(profilers.getClient(), session);
            List<SeriesData<AllocationSamplingRateDurationData>> list = series.getDataForRange(new Range((double)startTimeUs, (double)endTimeUs));
            Intrinsics.checkNotNullExpressionValue(list, (String)"series.getDataForRange(R\u2026), endTimeUs.toDouble()))");
            List<SeriesData<AllocationSamplingRateDurationData>> samplingModes = list;
            return samplingModes.size() == 1 && ((AllocationSamplingRateDurationData)samplingModes.get((int)0).value).getCurrentRate().getSamplingNumInterval() == BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
        }

        @JvmStatic
        public final void saveHeapDumpToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
            this.saveToFile(client, session, info.getStartTime(), outputStream, (Function0<Unit>)((Function0)new Function0<Unit>((Object)featureTracker){

                public final void invoke() {
                    ((FeatureTracker)this.receiver).trackExportHeap();
                }
            }), "Failed to export heap dump file");
        }

        @JvmStatic
        public final void saveLegacyAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
            this.saveToFile(client, session, info.getStartTime(), outputStream, (Function0<Unit>)((Function0)new Function0<Unit>((Object)featureTracker){

                public final void invoke() {
                    ((FeatureTracker)this.receiver).trackExportAllocation();
                }
            }), "Failed to export allocation records");
        }

        @JvmStatic
        public final void saveHeapProfdSampleToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Trace.TraceInfo info, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            this.saveToFile(client, session, info.getFromTimestamp(), outputStream, (Function0<Unit>)((Function0)saveHeapProfdSampleToFile.1.INSTANCE), "Failed to export native allocation records");
        }

        private final void saveToFile(ProfilerClient client, Common.Session session, long startTime, OutputStream outputStream, Function0<Unit> onFinished, String errorMsg) {
            Transport.BytesResponse response = client.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(session.getStreamId()).setId(String.valueOf(startTime)).build());
            if (response.getContents() != ByteString.EMPTY) {
                try {
                    response.getContents().writeTo(outputStream);
                    onFinished.invoke();
                }
                catch (IOException exception) {
                    this.getLogger().warn(errorMsg + ":\n" + exception);
                }
            }
        }

        @JvmStatic
        @NotNull
        public final String generateCaptureFileName() {
            return "memory-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss"));
        }

        @JvmStatic
        @NotNull
        public final List<Trace.TraceInfo> getNativeHeapSamplesForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_TRACE, getNativeHeapSamplesForSession.1.INSTANCE);
        }

        @JvmStatic
        @NotNull
        public final List<Common.Event> getNativeHeapEventsForSessionSortedByTimestamp(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return CollectionsKt.sortedWith((Iterable)this.getForSession(client, session, rangeUs, Common.Event.Kind.TRACE_STATUS, getNativeHeapEventsForSessionSortedByTimestamp.1.INSTANCE), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Common.Event it = (Common.Event)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (Common.Event)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            });
        }

        @JvmStatic
        @NotNull
        public final List<Memory.HeapDumpInfo> getHeapDumpsForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_HEAP_DUMP, getHeapDumpsForSession.1.INSTANCE);
        }

        @JvmStatic
        @NotNull
        public final List<Memory.AllocationsInfo> getAllocationInfosForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_ALLOC_TRACKING, (Function1)new Function1<Transport.EventGroup, Memory.AllocationsInfo>(session){
                final /* synthetic */ Common.Session $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final Memory.AllocationsInfo invoke(@NotNull Transport.EventGroup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Memory.AllocationsInfo info = MemoryProfilerKt.access$last(it).getMemoryAllocTracking().getInfo();
                    if (Intrinsics.areEqual((Object)info, (Object)Memory.AllocationsInfo.getDefaultInstance())) {
                        boolean bl;
                        boolean bl2 = bl = it.getEventsCount() > 1;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        info = it.getEvents(0).getMemoryAllocTracking().getInfo();
                        if (info.getLegacy() && info.getEndTime() == Long.MAX_VALUE) {
                            info = info.toBuilder().setEndTime(this.$session.getEndTimestamp()).setSuccess(false).build();
                        }
                    }
                    return info;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<T> getForSession(ProfilerClient client, Common.Session session, Range rangeUs, Common.Event.Kind eventKind, Function1<? super Transport.EventGroup, ? extends T> mapper) {
            void $this$mapTo$iv$iv;
            Transport.GetEventGroupsRequest it = Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(eventKind).setFromTimestamp(MemoryProfilerKt.access$microsToNanos(rangeUs.getMin())).setToTimestamp(MemoryProfilerKt.access$microsToNanos(rangeUs.getMax())).build();
            boolean bl = false;
            List list = client.getTransportClient().getEventGroups(it).getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"client.transportClient.g\u2026ventGroups(it).groupsList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(mapper.invoke(item$iv$iv));
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public final void trackAllocations(@NotNull StudioProfilers profilers, @NotNull Common.Session session, boolean enable, @Nullable Consumer<Memory.TrackStatus> responseHandler) {
            Commands.Command.Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            long timeNs = profilers.getClient().getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(session.getStreamId()).build()).getTimestampNs();
            Commands.Command.Builder $this$trackAllocations_u24lambda_u243 = builder = Commands.Command.newBuilder();
            boolean bl = false;
            $this$trackAllocations_u24lambda_u243.setStreamId(session.getStreamId());
            $this$trackAllocations_u24lambda_u243.setPid(session.getPid());
            if (enable) {
                $this$trackAllocations_u24lambda_u243.setType(Commands.Command.CommandType.START_ALLOC_TRACKING);
                $this$trackAllocations_u24lambda_u243.setStartAllocTracking(Memory.StartAllocTracking.newBuilder().setRequestTime(timeNs));
            } else {
                $this$trackAllocations_u24lambda_u243.setType(Commands.Command.CommandType.STOP_ALLOC_TRACKING);
                $this$trackAllocations_u24lambda_u243.setStopAllocTracking(Memory.StopAllocTracking.newBuilder().setRequestTime(timeNs));
            }
            Commands.Command.Builder trackCommand = builder;
            Transport.ExecuteResponse response = profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(trackCommand).build());
            if (responseHandler != null) {
                TransportEventListener statusListener2 = new TransportEventListener(Common.Event.Kind.MEMORY_ALLOC_TRACKING_STATUS, profilers.getIdeServices().getMainExecutor(), (Function1)new Function1<Common.Event, Boolean>(response){
                    final /* synthetic */ Transport.ExecuteResponse $response;
                    {
                        this.$response = $response;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Common.Event event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        return event.getCommandId() == this.$response.getCommandId();
                    }
                }, (Function0)new Function0<Long>(session){
                    final /* synthetic */ Common.Session $session;
                    {
                        this.$session = $session;
                        super(0);
                    }

                    @NotNull
                    public final Long invoke() {
                        return this.$session.getStreamId();
                    }
                }, (Function0)new Function0<Integer>(session){
                    final /* synthetic */ Common.Session $session;
                    {
                        this.$session = $session;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        return this.$session.getPid();
                    }
                }, null, null, null, (Function1)new Function1<Common.Event, Boolean>(responseHandler){
                    final /* synthetic */ Consumer<Memory.TrackStatus> $responseHandler;
                    {
                        this.$responseHandler = $responseHandler;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Common.Event event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Boolean bl = true;
                        Consumer<Memory.TrackStatus> consumer = this.$responseHandler;
                        boolean it = bl;
                        boolean bl2 = false;
                        consumer.accept(event.getMemoryAllocTrackingStatus().getStatus());
                        return bl;
                    }
                }, 224, null);
                profilers.getTransportPoller().registerListener(statusListener2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

