/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class MemoryUsage
extends LineChartModel {
    @NotNull
    private final Range myMemoryRange;
    @NotNull
    private final RangedContinuousSeries myTotalMemorySeries;
    static final int KB_TO_B = 1024;

    public MemoryUsage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryUsage.$$$reportNull$$$0(0);
        }
        this.myMemoryRange = new Range(0.0, 0.0);
        this.myTotalMemorySeries = this.createRangedSeries(profilers, this.getTotalSeriesLabel(), this.myMemoryRange, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> (long)e.getMemoryUsage().getTotalMem() * 1024L));
        this.add(this.myTotalMemorySeries);
    }

    protected RangedContinuousSeries createRangedSeries(@NotNull StudioProfilers profilers, @NotNull String name, @NotNull Range range, int groupId, Function<List<Common.Event>, List<SeriesData<Long>>> dataExtractor) {
        if (profilers == null) {
            MemoryUsage.$$$reportNull$$$0(1);
        }
        if (name == null) {
            MemoryUsage.$$$reportNull$$$0(2);
        }
        if (range == null) {
            MemoryUsage.$$$reportNull$$$0(3);
        }
        TransportServiceGrpc.TransportServiceBlockingStub client = profilers.getClient().getTransportClient();
        UnifiedEventDataSeries series = new UnifiedEventDataSeries(client, profilers.getSession().getStreamId(), profilers.getSession().getPid(), Common.Event.Kind.MEMORY_USAGE, groupId, dataExtractor);
        return new RangedContinuousSeries(name, profilers.getTimeline().getViewRange(), range, series, profilers.getTimeline().getDataRange());
    }

    @NotNull
    public Range getMemoryRange() {
        Range range = this.myMemoryRange;
        if (range == null) {
            MemoryUsage.$$$reportNull$$$0(4);
        }
        return range;
    }

    @NotNull
    public RangedContinuousSeries getTotalMemorySeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myTotalMemorySeries;
        if (rangedContinuousSeries == null) {
            MemoryUsage.$$$reportNull$$$0(5);
        }
        return rangedContinuousSeries;
    }

    protected String getTotalSeriesLabel() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalMemorySeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRangedSeries";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

