/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.SimpleColumnRenderer;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import java.awt.Color;
import java.awt.Graphics;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \"*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\"B[\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\u0002\u0010\rJB\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0002J\u0010\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/profilers/memory/PercentColumnRenderer;", "T", "Lcom/android/tools/profilers/memory/adapters/MemoryObject;", "Lcom/android/tools/profilers/memory/SimpleColumnRenderer;", "textGetter", "Ljava/util/function/Function;", "Lcom/android/tools/profilers/memory/MemoryObjectTreeNode;", "", "iconGetter", "Ljavax/swing/Icon;", "alignment", "", "percentGetter", "(Ljava/util/function/Function;Ljava/util/function/Function;ILjava/util/function/Function;)V", "hasFocus", "", "percent", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "getSparklineAccentColor", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "getSparklineColor", "paintComponent", "g", "Ljava/awt/Graphics;", "Companion", "intellij.android.profilers.ui"})
public final class PercentColumnRenderer<T extends MemoryObject>
extends SimpleColumnRenderer<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function<MemoryObjectTreeNode<T>, Integer> percentGetter;
    private int percent;
    private boolean hasFocus;
    @Deprecated
    public static final int ACCENT_BAR_WIDTH = 2;

    public PercentColumnRenderer(@NotNull Function<MemoryObjectTreeNode<T>, String> textGetter, @NotNull Function<MemoryObjectTreeNode<T>, Icon> iconGetter, int alignment, @NotNull Function<MemoryObjectTreeNode<T>, Integer> percentGetter) {
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        Intrinsics.checkNotNullParameter(iconGetter, (String)"iconGetter");
        Intrinsics.checkNotNullParameter(percentGetter, (String)"percentGetter");
        super(textGetter, iconGetter, alignment);
        this.percentGetter = percentGetter;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.percent > 0) {
            g.setColor(this.getSparklineColor());
            int barWidth = this.getWidth() * this.percent / 100;
            g.fillRect(this.getWidth() - barWidth, 0, barWidth, this.getHeight());
            g.setColor(this.getSparklineAccentColor());
            g.fillRect(this.getWidth() - barWidth, this.getHeight() - 2, barWidth, 2);
        }
        super.paintComponent(g);
    }

    private final Color getSparklineColor() {
        return !this.mySelected ? ProfilerColors.CAPTURE_SPARKLINE : (this.hasFocus ? ProfilerColors.CAPTURE_SPARKLINE_SELECTED : (Color)StudioColorsKt.getContentDeselectionBackground());
    }

    private final Color getSparklineAccentColor() {
        return !this.mySelected ? ProfilerColors.CAPTURE_SPARKLINE_ACCENT : (this.hasFocus ? ProfilerColors.CAPTURE_SPARKLINE_SELECTED_ACCENT : (Color)StudioColorsKt.getContentDeselectionBackground());
    }

    @Override
    public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof MemoryObjectTreeNode) {
            this.hasFocus = hasFocus;
            Integer n = this.percentGetter.apply((MemoryObjectTreeNode)value);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"percentGetter.apply(valu\u2026 MemoryObjectTreeNode<T>)");
            this.percent = ((Number)n).intValue();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/profilers/memory/PercentColumnRenderer$Companion;", "", "()V", "ACCENT_BAR_WIDTH", "", "intellij.android.profilers.ui"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

