/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public final class ClassDb {
    public static final int INVALID_CLASS_ID = -1;
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final Map<Long, ClassEntry> myClassEntries = new HashMap<Long, ClassEntry>();
    private boolean myResolvedSubclasses = false;

    public void clear() {
        this.myClassEntries.clear();
        this.myResolvedSubclasses = false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classId, @NotNull String string) {
        void className;
        if (string == null) {
            ClassDb.$$$reportNull$$$0(0);
        }
        ClassEntry classEntry = this.registerClass(classId, (String)className, -1L);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(1);
        }
        return classEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classId, @NotNull String className, long l) {
        void retainedSize;
        if (className == null) {
            ClassDb.$$$reportNull$$$0(2);
        }
        ClassEntry classEntry = this.registerClass(classId, -1L, className, (long)retainedSize);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(3);
        }
        return classEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classId, long superClassId, @NotNull String string) {
        void className;
        if (string == null) {
            ClassDb.$$$reportNull$$$0(4);
        }
        ClassEntry classEntry = this.registerClass(classId, superClassId, (String)className, -1L);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(5);
        }
        return classEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classId, long superClassId, @NotNull String string, long l) {
        void className;
        ClassEntry entry2;
        if (string == null) {
            ClassDb.$$$reportNull$$$0(6);
        }
        if ((entry2 = this.myClassEntries.get(classId)) == null || superClassId != entry2.mySuperClassId || !className.equals(entry2.myClassName)) {
            void retainedSize;
            entry2 = new ClassEntry(classId, superClassId, (String)className, (long)retainedSize);
            this.myClassEntries.put(classId, entry2);
        }
        ClassEntry classEntry = entry2;
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(7);
        }
        return classEntry;
    }

    @NotNull
    public ClassEntry getEntry(long classId) {
        assert (this.myClassEntries.containsKey(classId));
        ClassEntry classEntry = this.myClassEntries.get(classId);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(8);
        }
        return classEntry;
    }

    @NotNull
    public Set<ClassEntry> getEntriesByName(@NotNull String className) {
        if (className == null) {
            ClassDb.$$$reportNull$$$0(9);
        }
        HashSet<ClassEntry> entries = new HashSet<ClassEntry>();
        for (ClassEntry entry2 : this.myClassEntries.values()) {
            if (!entry2.getClassName().equals(className)) continue;
            entries.add(entry2);
        }
        HashSet<ClassEntry> hashSet = entries;
        if (hashSet == null) {
            ClassDb.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    public Set<ClassEntry> getDescendantClasses(long classId) {
        this.resolveSubClasses();
        ClassEntry klass = this.getEntry(classId);
        HashSet<ClassEntry> descendants = new HashSet<ClassEntry>();
        Stack<ClassEntry> searchStack = new Stack<ClassEntry>();
        searchStack.push(klass);
        while (!searchStack.isEmpty()) {
            ClassEntry searchEntry = (ClassEntry)searchStack.pop();
            descendants.add(searchEntry);
            for (long subClassId : searchEntry.getSubClassIds()) {
                searchStack.push(this.getEntry(subClassId));
            }
        }
        return descendants;
    }

    private boolean resolveSubClasses() {
        if (this.myResolvedSubclasses) {
            return false;
        }
        for (ClassEntry entry2 : this.myClassEntries.values()) {
            long superClassId = entry2.getSuperClassId();
            if (superClassId == -1L) continue;
            this.getEntry(superClassId).getSubClassIds().add(entry2.getClassId());
        }
        this.myResolvedSubclasses = true;
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassDb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassDb";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "registerClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEntriesByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    public static class ClassEntry {
        @NotNull
        private final Set<Long> mySubClassIds;
        @NotNull
        private final long myClassId;
        @NotNull
        private final long mySuperClassId;
        @NotNull
        private final String myClassName;
        @NotNull
        private final String[] mySplitPackageName;
        private final long myRetainedSize;

        /*
         * WARNING - void declaration
         */
        public ClassEntry(long classId, long superClassId, @NotNull String string, long l) {
            void retainedSize;
            void className;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(0);
            }
            this.mySubClassIds = new HashSet<Long>();
            this.myClassId = classId;
            this.mySuperClassId = superClassId;
            this.myClassName = className;
            String packageName = this.getPackageName();
            this.mySplitPackageName = packageName.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : packageName.split("\\.");
            this.myRetainedSize = retainedSize;
        }

        /*
         * WARNING - void declaration
         */
        public ClassEntry(long classId, long superClassId, @NotNull String string) {
            void className;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(1);
            }
            this(classId, superClassId, (String)className, -1L);
        }

        public long getClassId() {
            return this.myClassId;
        }

        public long getSuperClassId() {
            return this.mySuperClassId;
        }

        public Set<Long> getSubClassIds() {
            return this.mySubClassIds;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getPackageName() {
            int lastIndexOfDot = this.getLastIndexOfDot();
            return lastIndexOfDot > 0 ? this.myClassName.substring(0, lastIndexOfDot) : "";
        }

        @NotNull
        public String[] getSplitPackageName() {
            if (this.mySplitPackageName == null) {
                ClassEntry.$$$reportNull$$$0(3);
            }
            return this.mySplitPackageName;
        }

        @NotNull
        public String getSimpleClassName() {
            String string = this.myClassName.substring(this.getLastIndexOfDot() + 1);
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(4);
            }
            return string;
        }

        public long getRetainedSize() {
            return this.myRetainedSize;
        }

        public int hashCode() {
            return this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassEntry && this.myClassName.equals(((ClassEntry)obj).myClassName);
        }

        private int getLastIndexOfDot() {
            return this.myClassName.lastIndexOf(46);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassDb$ClassEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassDb$ClassEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSplitPackageName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

