/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Type;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HeapDumpFieldObject
implements FieldObject {
    private static final Map<Type, ValueObject.ValueType> ourPrimitiveValueTypeMap = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)ValueObject.ValueType.BOOLEAN).put((Object)Type.BYTE, (Object)ValueObject.ValueType.BYTE).put((Object)Type.CHAR, (Object)ValueObject.ValueType.CHAR).put((Object)Type.SHORT, (Object)ValueObject.ValueType.SHORT).put((Object)Type.INT, (Object)ValueObject.ValueType.INT).put((Object)Type.LONG, (Object)ValueObject.ValueType.LONG).put((Object)Type.FLOAT, (Object)ValueObject.ValueType.FLOAT).put((Object)Type.DOUBLE, (Object)ValueObject.ValueType.DOUBLE).build();
    @NotNull
    private final ClassInstance.FieldValue myField;
    @NotNull
    private final ValueObject.ValueType myValueType;
    @Nullable
    private final InstanceObject myInstanceObject;
    private final int myDepth;
    private final long myNativeSize;
    private final int myShallowSize;
    private final long myRetainedSize;
    private final int myHashCode;

    public HeapDumpFieldObject(@NotNull HeapDumpCaptureObject captureObject, @NotNull Instance parentInstance, @NotNull ClassInstance.FieldValue field) {
        if (captureObject == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(0);
        }
        if (parentInstance == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(1);
        }
        if (field == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(2);
        }
        this.myField = field;
        Type type = this.myField.getField().getType();
        if (type == Type.OBJECT) {
            Instance instance = (Instance)this.myField.getValue();
            if (instance == null || this.myField.getValue() == null) {
                this.myValueType = ValueObject.ValueType.NULL;
                this.myInstanceObject = null;
                this.myNativeSize = 0L;
                this.myShallowSize = 0;
                this.myRetainedSize = 0L;
                this.myDepth = Integer.MAX_VALUE;
            } else {
                this.myInstanceObject = captureObject.findInstanceObject(instance);
                this.myValueType = instance instanceof ClassObj ? ValueObject.ValueType.CLASS : (instance instanceof ArrayInstance ? ValueObject.ValueType.ARRAY : (instance instanceof ClassInstance && instance.getClassObj().getClassName().equals("java.lang.String") ? ValueObject.ValueType.STRING : ValueObject.ValueType.OBJECT));
                this.myNativeSize = instance.getNativeSize();
                this.myShallowSize = instance.getSize();
                this.myRetainedSize = instance.getTotalRetainedSize();
                this.myDepth = instance.getDistanceToGcRoot();
            }
        } else {
            this.myValueType = ourPrimitiveValueTypeMap.getOrDefault(type, ValueObject.ValueType.NULL);
            this.myInstanceObject = null;
            this.myNativeSize = 0L;
            this.myShallowSize = type.getSize();
            this.myRetainedSize = type.getSize();
            this.myDepth = parentInstance.getDistanceToGcRoot();
        }
        this.myHashCode = Arrays.hashCode(new Object[]{this.myInstanceObject, this.getFieldName(), this.getValueType(), this.myField.getValue()});
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeapDumpFieldObject)) {
            return false;
        }
        HeapDumpFieldObject other = (HeapDumpFieldObject)obj;
        return other.myInstanceObject == this.myInstanceObject && this.getFieldName().equals(other.getFieldName()) && this.getValueType() == other.getValueType() && (this.getAsInstance() == other.getAsInstance() || Objects.equals(this.myField.getValue(), other.myField.getValue()));
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getFieldName();
        if (string == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public long getNativeSize() {
        return this.myNativeSize;
    }

    @Override
    public int getShallowSize() {
        return this.myShallowSize;
    }

    @Override
    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    @Override
    public int getDepth() {
        return this.myDepth;
    }

    @Override
    @NotNull
    public String getFieldName() {
        String string = this.myField.getField().getName();
        if (string == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public InstanceObject getAsInstance() {
        return this.myInstanceObject;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.myInstanceObject != null ? this.myInstanceObject : this.myField.getValue();
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        ValueObject.ValueType valueType = this.myValueType;
        if (valueType == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(5);
        }
        return valueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        if (this.getValueType().getIsPrimitive()) {
            return "";
        }
        if (this.getValueType() == ValueObject.ValueType.NULL || this.myField.getValue() == null || this.myInstanceObject == null) {
            return "null";
        }
        String string = String.format("{%s}", this.myInstanceObject.getClassEntry().getSimpleClassName());
        if (string == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getToStringText() {
        if (this.getValueType() == ValueObject.ValueType.NULL || this.myField.getValue() == null) {
            return "";
        }
        if (this.getValueType().getIsPrimitive()) {
            String string = this.myField.getValue().toString();
            if (string == null) {
                HeapDumpFieldObject.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.myInstanceObject == null ? "" : this.myInstanceObject.getToStringText();
        if (string == null) {
            HeapDumpFieldObject.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/HeapDumpFieldObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/HeapDumpFieldObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getToStringText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

