/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAllocationInstanceObject
implements InstanceObject {
    @NotNull
    private final Memory.AllocationEvent.Allocation myEvent;
    @NotNull
    private final ClassDb.ClassEntry myAllocationClassEntry;
    @NotNull
    private final Memory.AllocationStack myCallStack;
    @NotNull
    private final ValueObject.ValueType myValueType;
    private final boolean myIsAllocation;
    private final int myCount;

    public NativeAllocationInstanceObject(@NotNull Memory.AllocationEvent.Allocation event, @NotNull ClassDb.ClassEntry allocationClassEntry, @NotNull Memory.AllocationStack callStack, long count2) {
        if (event == null) {
            NativeAllocationInstanceObject.$$$reportNull$$$0(0);
        }
        if (allocationClassEntry == null) {
            NativeAllocationInstanceObject.$$$reportNull$$$0(1);
        }
        if (callStack == null) {
            NativeAllocationInstanceObject.$$$reportNull$$$0(2);
        }
        this.myEvent = event;
        this.myAllocationClassEntry = allocationClassEntry;
        this.myCallStack = callStack;
        this.myValueType = ValueObject.ValueType.BYTE;
        this.myIsAllocation = count2 > 0L;
        this.myCount = (int)Math.abs(count2);
    }

    @Override
    public int getInstanceCount() {
        return this.myCount;
    }

    @Override
    public int getHeapId() {
        return 0;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        ClassDb.ClassEntry classEntry = this.myAllocationClassEntry;
        if (classEntry == null) {
            NativeAllocationInstanceObject.$$$reportNull$$$0(3);
        }
        return classEntry;
    }

    @Override
    public boolean hasTimeData() {
        return true;
    }

    @Override
    public boolean hasAllocTime() {
        return this.myIsAllocation;
    }

    @Override
    public boolean hasDeallocTime() {
        return !this.myIsAllocation;
    }

    @Override
    @Nullable
    public Memory.AllocationStack getAllocationCallStack() {
        return this.myCallStack;
    }

    @Override
    public long getNativeSize() {
        return this.myEvent.getSize();
    }

    @Override
    public long getRetainedSize() {
        return this.myEvent.getSize();
    }

    @Override
    public int getShallowSize() {
        return (int)this.myEvent.getSize();
    }

    @Override
    public int getCallStackDepth() {
        Memory.AllocationStack callStack = this.getAllocationCallStack();
        if (callStack == null) {
            return 0;
        }
        return callStack.getFullStack().getFramesCount();
    }

    @Override
    public boolean getIsRoot() {
        return InstanceObject.super.getIsRoot();
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        ValueObject.ValueType valueType = this.myValueType;
        if (valueType == null) {
            NativeAllocationInstanceObject.$$$reportNull$$$0(4);
        }
        return valueType;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myAllocationClassEntry.getClassName();
        if (string == null) {
            NativeAllocationInstanceObject.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationClassEntry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStack";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/NativeAllocationInstanceObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/NativeAllocationInstanceObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassEntry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

