/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.PackageSet;
import com.android.tools.profilers.memory.adapters.classifiers.ThreadSet;
import org.jetbrains.annotations.NotNull;

public class HeapSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    protected ClassGrouping myClassGrouping;
    private final int myId;
    @NotNull
    private Filter myFilter;

    public HeapSet(@NotNull CaptureObject captureObject, @NotNull String heapName, int id) {
        if (captureObject == null) {
            HeapSet.$$$reportNull$$$0(0);
        }
        if (heapName == null) {
            HeapSet.$$$reportNull$$$0(1);
        }
        super(heapName);
        this.myClassGrouping = ClassGrouping.ARRANGE_BY_CLASS;
        this.myCaptureObject = captureObject;
        this.myId = id;
        this.myFilter = Filter.EMPTY_FILTER;
        this.setClassGrouping(ClassGrouping.ARRANGE_BY_CLASS);
    }

    public ClassGrouping getClassGrouping() {
        return this.myClassGrouping;
    }

    public void setClassGrouping(@NotNull ClassGrouping classGrouping) {
        if (classGrouping == null) {
            HeapSet.$$$reportNull$$$0(2);
        }
        if (this.myClassGrouping == classGrouping) {
            return;
        }
        this.myClassGrouping = classGrouping;
        this.coalesce();
        this.needsRefiltering = true;
    }

    public int getId() {
        return this.myId;
    }

    public void selectFilter(@NotNull Filter filter) {
        if (filter == null) {
            HeapSet.$$$reportNull$$$0(3);
        }
        if (this.myFilter.isEmpty() && filter.isEmpty()) {
            return;
        }
        boolean filterChanged = !this.myFilter.equals((Object)filter);
        this.myFilter = filter;
        this.applyFilter(filterChanged);
    }

    @NotNull
    public Filter getFilter() {
        Filter filter = this.myFilter;
        if (filter == null) {
            HeapSet.$$$reportNull$$$0(4);
        }
        return filter;
    }

    private void applyFilter(boolean filterChanged) {
        this.applyFilter(this.myFilter, filterChanged);
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        switch (this.myClassGrouping) {
            case ARRANGE_BY_CLASS: {
                Classifier classifier = ClassSet.createDefaultClassifier();
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(5);
                }
                return classifier;
            }
            case ARRANGE_BY_PACKAGE: {
                Classifier classifier = PackageSet.createDefaultClassifier(this.myCaptureObject);
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(6);
                }
                return classifier;
            }
            case ARRANGE_BY_CALLSTACK: {
                Classifier classifier = ThreadSet.createDefaultClassifier(this.myCaptureObject);
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(7);
                }
                return classifier;
            }
        }
        throw new RuntimeException("Classifier type not implemented: " + this.myClassGrouping);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classGrouping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/HeapSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/HeapSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubClassifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setClassGrouping";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

