/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.inspectors.common.api.stacktrace.ThreadId;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.MethodSet;
import org.jetbrains.annotations.NotNull;

public class ThreadSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private final ThreadId myThreadId;

    @NotNull
    public static Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        if (captureObject == null) {
            ThreadSet.$$$reportNull$$$0(0);
        }
        Classifier classifier = ThreadSet.threadClassifier(captureObject);
        if (classifier == null) {
            ThreadSet.$$$reportNull$$$0(1);
        }
        return classifier;
    }

    public ThreadSet(@NotNull CaptureObject captureObject, @NotNull ThreadId threadId) {
        if (captureObject == null) {
            ThreadSet.$$$reportNull$$$0(2);
        }
        if (threadId == null) {
            ThreadSet.$$$reportNull$$$0(3);
        }
        super(threadId.toString());
        this.myCaptureObject = captureObject;
        this.myThreadId = threadId;
    }

    @NotNull
    public ThreadId getThreadId() {
        ThreadId threadId = this.myThreadId;
        if (threadId == null) {
            ThreadSet.$$$reportNull$$$0(4);
        }
        return threadId;
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        Classifier classifier = MethodSet.createDefaultClassifier(this.myCaptureObject);
        if (classifier == null) {
            ThreadSet.$$$reportNull$$$0(5);
        }
        return classifier;
    }

    private static Classifier threadClassifier(CaptureObject captureObject) {
        return new Classifier.Join(inst -> {
            ThreadId threadId = inst.getAllocationThreadId();
            return threadId == ThreadId.INVALID_THREAD_ID ? null : threadId;
        }, id -> new ThreadSet(captureObject, (ThreadId)id), MethodSet.createDefaultClassifier(captureObject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/ThreadSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/ThreadSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultClassifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubClassifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultClassifier";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

