/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.RangeTimeScrollBar;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.HTreeChartVerticalScrollBar;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.memory.CapturePanelTabContainer;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.NativeAllocationSampleCaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode;
import com.android.tools.profilers.memory.chart.HeapSetNodeHRenderer;
import com.android.tools.profilers.memory.chart.MemoryVisualizationModel;
import com.android.tools.profilers.memory.chart.MemoryVisualizationTooltipView;
import com.android.tools.profilers.memory.chart.VisualizationTooltipModel;
import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001fH\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\u0018\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020*H\u0002R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lcom/android/tools/profilers/memory/chart/MemoryVisualizationView;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/android/tools/profilers/memory/CapturePanelTabContainer;", "selection", "Lcom/android/tools/profilers/memory/MemoryCaptureSelection;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "(Lcom/android/tools/profilers/memory/MemoryCaptureSelection;Lcom/android/tools/profilers/StudioProfilersView;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "initialClassGrouping", "Lcom/android/tools/profilers/memory/ClassGrouping;", "model", "Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;", "orderingDropdown", "Ljavax/swing/JComboBox;", "Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel$XAxisFilter;", "panel", "Ljavax/swing/JPanel;", "toolbarComponents", "", "Ljava/awt/Component;", "getToolbarComponents", "()Ljava/util/List;", "createAxis", "Lcom/android/tools/adtui/AxisComponent;", "formatter", "Lcom/android/tools/adtui/model/formatter/BaseAxisFormatter;", "range", "Lcom/android/tools/adtui/model/Range;", "createChart", "Lcom/android/tools/adtui/chart/hchart/HTreeChart;", "Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "node", "globalRange", "createChartPanel", "getCodeLocation", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "chart", "onSelectionChanged", "", "selected", "", "rebuildUI", "intellij.android.profilers.ui"})
public final class MemoryVisualizationView
extends AspectObserver
implements CapturePanelTabContainer {
    @NotNull
    private final MemoryCaptureSelection selection;
    @NotNull
    private final StudioProfilersView profilersView;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final JComboBox<MemoryVisualizationModel.XAxisFilter> orderingDropdown;
    @NotNull
    private final MemoryVisualizationModel model;
    @Nullable
    private ClassGrouping initialClassGrouping;

    public MemoryVisualizationView(@NotNull MemoryCaptureSelection selection, @NotNull StudioProfilersView profilersView) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)((Object)profilersView), (String)"profilersView");
        this.selection = selection;
        this.profilersView = profilersView;
        this.panel = new JPanel(new BorderLayout());
        this.orderingDropdown = (JComboBox)((Object)new ProfilerCombobox());
        this.model = new MemoryVisualizationModel();
        this.orderingDropdown.addActionListener(arg_0 -> MemoryVisualizationView._init_$lambda$0(this, arg_0));
        ComboBoxModel comboBoxModel = new DefaultComboBoxModel<MemoryVisualizationModel.XAxisFilter>(MemoryVisualizationModel.XAxisFilter.values());
        this.orderingDropdown.setModel(comboBoxModel);
        this.orderingDropdown.setSelectedIndex(MemoryVisualizationModel.XAxisFilter.ALLOC_SIZE.ordinal());
    }

    @NotNull
    public final List<Component> getToolbarComponents() {
        List components = new ArrayList();
        components.add(this.orderingDropdown);
        return components;
    }

    @Override
    public void onSelectionChanged(boolean selected) {
        if (selected) {
            this.selection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_FILTER, () -> MemoryVisualizationView.onSelectionChanged$lambda$1(this));
            Object object = this.selection.getSelectedHeapSet();
            if (object == null || (object = object.getClassGrouping()) == null) {
                return;
            }
            this.initialClassGrouping = object;
            this.rebuildUI();
            this.selection.getFilterHandler().refreshFilterContent();
        } else {
            this.selection.getAspect().removeDependencies((AspectObserver)this);
            HeapSet heapSet = this.selection.getSelectedHeapSet();
            if (heapSet != null) {
                ClassGrouping classGrouping = this.initialClassGrouping;
                if (classGrouping == null) {
                    return;
                }
                heapSet.setClassGrouping(classGrouping);
            }
            this.selection.getFilterHandler().refreshFilterContent();
        }
    }

    private final void rebuildUI() {
        HeapSet heapSet = this.selection.getSelectedHeapSet();
        if (heapSet != null) {
            heapSet.setClassGrouping(this.selection.getSelectedCapture() instanceof NativeAllocationSampleCaptureObject ? ClassGrouping.NATIVE_ARRANGE_BY_CALLSTACK : ClassGrouping.ARRANGE_BY_CALLSTACK);
        }
        this.panel.removeAll();
        this.panel.add((Component)this.createChartPanel(), "Center");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    private final JPanel createChartPanel() {
        if (this.selection.getSelectedHeapSet() == null) {
            return new JPanel();
        }
        HeapSet heapSet = this.selection.getSelectedHeapSet();
        Intrinsics.checkNotNull((Object)heapSet);
        ClassifierSetHNode selected = new ClassifierSetHNode(this.model, heapSet, 0);
        selected.updateChildrenOffsets();
        Range captureRange = new Range(0.0, (double)selected.getEnd());
        Range globalRange = new Range(captureRange);
        RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(globalRange, captureRange, TimeUnit.MICROSECONDS);
        horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
        AxisComponent axis = this.createAxis(this.model.formatter(), captureRange);
        HTreeChart<ClassifierSetHNode> chart2 = this.createChart(selected, captureRange, globalRange);
        JComponent jComponent = this.profilersView.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"profilersView.component");
        chart2.addMouseMotionListener((MouseMotionListener)new MemoryVisualizationTooltipView(chart2, jComponent, new VisualizationTooltipModel(captureRange, this.model)));
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
        panel.add((Component)axis, new TabularLayout.Constraint(0, 0, 0, 4, null));
        panel.add((Component)chart2, new TabularLayout.Constraint(0, 0, 0, 4, null));
        panel.add((Component)new HTreeChartVerticalScrollBar(chart2), new TabularLayout.Constraint(0, 1, 0, 4, null));
        panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
        CodeNavigator navigator = this.profilersView.getStudioProfilers().getIdeServices().getCodeNavigator();
        this.profilersView.getIdeProfilerComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart2, navigator, () -> MemoryVisualizationView.createChartPanel$lambda$2(this, chart2));
        return panel;
    }

    private final CodeLocation getCodeLocation(HTreeChart<ClassifierSetHNode> chart2) {
        ClassifierSet nativeSet;
        ClassifierSetHNode classifierSetHNode = (ClassifierSetHNode)chart2.getFocusedNode();
        ClassifierSet classifierSet = nativeSet = classifierSetHNode != null ? classifierSetHNode.getData() : null;
        if (nativeSet instanceof NativeCallStackSet && !Strings.isNullOrEmpty((String)((NativeCallStackSet)nativeSet).getFileName())) {
            return new CodeLocation.Builder(((NativeCallStackSet)nativeSet).getName()).setMethodName(((NativeCallStackSet)nativeSet).getName()).setFileName(((NativeCallStackSet)nativeSet).getFileName()).setLineNumber(((NativeCallStackSet)nativeSet).getLineNumber() - 1).build();
        }
        return null;
    }

    private final AxisComponent createAxis(BaseAxisFormatter formatter, Range range) {
        ResizingAxisComponentModel resizingAxisComponentModel = new ResizingAxisComponentModel.Builder(range, formatter).build();
        Intrinsics.checkNotNullExpressionValue((Object)resizingAxisComponentModel, (String)"Builder(range, formatter).build()");
        AxisComponentModel axisModel = (AxisComponentModel)resizingAxisComponentModel;
        AxisComponent axis = new AxisComponent(axisModel, AxisComponent.AxisOrientation.BOTTOM, true);
        axis.setShowAxisLine(false);
        axis.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
        axis.addComponentListener((ComponentListener)new ComponentAdapter(axis){
            final /* synthetic */ AxisComponent $axis;
            {
                this.$axis = $axis;
            }

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$axis.setMarkerLengths(this.$axis.getHeight(), 0);
                this.$axis.repaint();
            }
        });
        return axis;
    }

    private final HTreeChart<ClassifierSetHNode> createChart(ClassifierSetHNode node, Range range, Range globalRange) {
        HTreeChart hTreeChart;
        HTreeChart.Orientation orientation = HTreeChart.Orientation.TOP_DOWN;
        HTreeChart $this$createChart_u24lambda_u243 = hTreeChart = new HTreeChart.Builder((HNode)node, range, (HRenderer)new HeapSetNodeHRenderer()).setGlobalXRange(globalRange).setOrientation(orientation).setRootVisible(false).build();
        boolean bl = false;
        $this$createChart_u24lambda_u243.setDrawDebugInfo(this.profilersView.getStudioProfilers().getIdeServices().getFeatureConfig().isPerformanceMonitoringEnabled());
        return hTreeChart;
    }

    private static final void _init_$lambda$0(MemoryVisualizationView this$0, ActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object item = this$0.orderingDropdown.getSelectedItem();
        if (item instanceof MemoryVisualizationModel.XAxisFilter) {
            this$0.model.setAxisFilter((MemoryVisualizationModel.XAxisFilter)((Object)item));
            this$0.rebuildUI();
        }
    }

    private static final void onSelectionChanged$lambda$1(MemoryVisualizationView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rebuildUI();
    }

    private static final CodeLocation createChartPanel$lambda$2(MemoryVisualizationView this$0, HTreeChart $chart) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$chart, (String)"$chart");
        return this$0.getCodeLocation((HTreeChart<ClassifierSetHNode>)$chart);
    }
}

