/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.MainProcessSelector;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.systemtrace.ProcessListSorter;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCaptureBuilder;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import perfetto.protos.PerfettoTrace;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/profilers/perfetto/PerfettoParser;", "Lcom/android/tools/profilers/cpu/TraceParser;", "mainProcessSelector", "Lcom/android/tools/profilers/cpu/MainProcessSelector;", "ideProfilerServices", "Lcom/android/tools/profilers/IdeProfilerServices;", "(Lcom/android/tools/profilers/cpu/MainProcessSelector;Lcom/android/tools/profilers/IdeProfilerServices;)V", "parse", "Lcom/android/tools/profilers/cpu/CpuCapture;", "file", "Ljava/io/File;", "traceId", "", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nPerfettoParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoParser.kt\ncom/android/tools/profilers/perfetto/PerfettoParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n223#3,2:100\n*S KotlinDebug\n*F\n+ 1 PerfettoParser.kt\ncom/android/tools/profilers/perfetto/PerfettoParser\n*L\n84#1:100,2\n*E\n"})
public final class PerfettoParser
implements TraceParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MainProcessSelector mainProcessSelector;
    @NotNull
    private final IdeProfilerServices ideProfilerServices;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Object TPD_LOCK;

    public PerfettoParser(@NotNull MainProcessSelector mainProcessSelector, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)mainProcessSelector, (String)"mainProcessSelector");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        this.mainProcessSelector = mainProcessSelector;
        this.ideProfilerServices = ideProfilerServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CpuCapture parse(@NotNull File file, long traceId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = TPD_LOCK;
        synchronized (object) {
            Object v4;
            Collection collection;
            ProcessModel selectedProcess;
            Integer userSelectedProcess;
            Range initialViewRange;
            TraceProcessorService traceProcessor;
            block20: {
                Object element$iv2;
                Object object22;
                List<ProcessModel> processList;
                block19: {
                    ProcessListSorter processListSorter;
                    boolean bl = false;
                    traceProcessor = this.ideProfilerServices.getTraceProcessorService();
                    boolean traceLoaded = traceProcessor.loadTrace(traceId, file, this.ideProfilerServices);
                    if (!traceLoaded) {
                        throw new IllegalStateException("Unable to load trace with TPD.".toString());
                    }
                    processList = traceProcessor.getProcessMetadata(traceId, this.ideProfilerServices);
                    if (!(!((Collection)processList).isEmpty())) {
                        boolean $i$a$-check-PerfettoParser$parse$1$22 = false;
                        String $i$a$-check-PerfettoParser$parse$1$22 = "Invalid trace without any process information.";
                        throw new IllegalStateException($i$a$-check-PerfettoParser$parse$1$22.toString());
                    }
                    List<String> traceUIMetadata = traceProcessor.getTraceMetadata(traceId, "ui_state", this.ideProfilerServices);
                    Object processHint = this.mainProcessSelector.getNameHint();
                    initialViewRange = new Range();
                    if (!((Collection)traceUIMetadata).isEmpty()) {
                        try {
                            PerfettoTrace.UiState uiState = PerfettoTrace.UiState.parseFrom((byte[])Base64.getDecoder().decode((String)CollectionsKt.last(traceUIMetadata)));
                            if (uiState.getHighlightProcess().hasPid()) {
                                Object object3;
                                Object v0;
                                block18: {
                                    int wantedProcessId = uiState.getHighlightProcess().getPid();
                                    Iterable iterable = processList;
                                    for (Object object22 : iterable) {
                                        ProcessModel it = (ProcessModel)object22;
                                        boolean bl2 = false;
                                        if (!(it.getId() == wantedProcessId)) continue;
                                        v0 = object22;
                                        break block18;
                                    }
                                    v0 = null;
                                }
                                if ((object3 = (ProcessModel)v0) == null || (object3 = ((ProcessModel)object3).getSafeProcessName()) == null) {
                                    object3 = this.mainProcessSelector.getNameHint();
                                }
                                processHint = object3;
                            } else if (uiState.getHighlightProcess().hasCmdline()) {
                                String string = uiState.getHighlightProcess().getCmdline();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uiState.highlightProcess.cmdline");
                                processHint = string;
                            }
                            if (uiState.getTimelineStartTs() != 0L && uiState.getTimelineEndTs() != 0L) {
                                initialViewRange.set((double)TimeUnit.NANOSECONDS.toMicros(uiState.getTimelineStartTs()), (double)TimeUnit.NANOSECONDS.toMicros(uiState.getTimelineEndTs()));
                            }
                        }
                        catch (Throwable throwable) {
                            LOGGER.warn("Trace contained ui-state, however it failed to parse correctly. Ui state will not be loaded", throwable);
                        }
                    }
                    if ((userSelectedProcess = this.mainProcessSelector.apply((processListSorter = new ProcessListSorter((String)processHint)).sort(processList))) == null) {
                        boolean $i$a$-checkNotNull-PerfettoParser$parse$1$42 = false;
                        String $i$a$-checkNotNull-PerfettoParser$parse$1$42 = "It was not possible to select a process for this trace.";
                        throw new IllegalStateException($i$a$-checkNotNull-PerfettoParser$parse$1$42.toString());
                    }
                    Iterable $this$first$iv = processList;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ProcessModel processModel = (ProcessModel)element$iv2;
                        boolean bl3 = false;
                        Integer n = userSelectedProcess;
                        if (!(n != null && processModel.getId() == n.intValue())) continue;
                        break block19;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                selectedProcess = (ProcessModel)element$iv2;
                Iterable $i$f$first = processList;
                collection = CollectionsKt.listOf((Object)selectedProcess);
                Iterable iterable = $i$f$first;
                object22 = iterable.iterator();
                while (object22.hasNext()) {
                    Object e = object22.next();
                    ProcessModel it = (ProcessModel)e;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it.getSafeProcessName(), (String)"surfaceflinger", (boolean)false, (int)2, null)) continue;
                    v4 = e;
                    break block20;
                }
                v4 = null;
            }
            List processesToQuery = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull(v4)));
            SystemTraceModelAdapter model = traceProcessor.loadCpuData(traceId, processesToQuery, selectedProcess, this.ideProfilerServices);
            SystemTraceCpuCaptureBuilder builder = new SystemTraceCpuCaptureBuilder(model);
            if (initialViewRange.isEmpty()) {
                initialViewRange.set((double)model.getCaptureStartTimestampUs(), (double)model.getCaptureEndTimestampUs());
            }
            CpuCapture cpuCapture = builder.build(traceId, userSelectedProcess, initialViewRange);
            return cpuCapture;
        }
    }

    static {
        Logger logger = Logger.getInstance(PerfettoParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(PerfettoParser::class.java)");
        LOGGER = logger;
        TPD_LOCK = new Object();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/profilers/perfetto/PerfettoParser$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TPD_LOCK", "getTPD_LOCK", "()Ljava/lang/Object;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getTPD_LOCK() {
            return TPD_LOCK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

