/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.extras;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import trebuchet.extras.InputStreamAdapter;
import trebuchet.model.Model;
import trebuchet.task.ImportTask;
import trebuchet.util.PrintlnImportFeedback;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"findSampleData", "", "openSample", "Ltrebuchet/model/Model;", "name", "parseTrace", "file", "Ljava/io/File;", "intellij.android.profilers.atrace"})
public final class ImportUtilsKt {
    @NotNull
    public static final Model parseTrace(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        long before = System.nanoTime();
        ImportTask task = new ImportTask(new PrintlnImportFeedback());
        Model model = task.import(new InputStreamAdapter(file));
        long after = System.nanoTime();
        long duration = (after - before) / (long)1000000;
        System.out.println((Object)("Parsing " + file.getName() + " took " + duration + "ms"));
        return model;
    }

    @NotNull
    public static final String findSampleData() {
        Object path = "sample_data";
        while (!new File((String)path).exists()) {
            path = "../" + (String)path;
        }
        return path;
    }

    @NotNull
    public static final Model openSample(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ImportUtilsKt.parseTrace(new File(ImportUtilsKt.findSampleData(), name));
    }
}

