/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.model.fragments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.CpuProcessSlice;
import trebuchet.model.fragments.ProcessModelFragment;
import trebuchet.model.fragments.ThreadModelFragment;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\t\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0018R\u0014\u0010$\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001c\u00a8\u0006'"}, d2={"Ltrebuchet/model/fragments/SchedulingProcessFragment;", "Ltrebuchet/model/CpuProcessSlice;", "process", "Ltrebuchet/model/fragments/ProcessModelFragment;", "thread", "Ltrebuchet/model/fragments/ThreadModelFragment;", "startTime", "", "(Ltrebuchet/model/fragments/ProcessModelFragment;Ltrebuchet/model/fragments/ThreadModelFragment;D)V", "cpuTime", "getCpuTime", "()D", "setCpuTime", "(D)V", "didNotFinish", "", "getDidNotFinish", "()Z", "endTime", "getEndTime", "setEndTime", "id", "", "getId", "()I", "name", "", "getName", "()Ljava/lang/String;", "getProcess", "()Ltrebuchet/model/fragments/ProcessModelFragment;", "getStartTime", "getThread", "()Ltrebuchet/model/fragments/ThreadModelFragment;", "threadId", "getThreadId", "threadName", "getThreadName", "Builder", "intellij.android.profilers.atrace"})
public final class SchedulingProcessFragment
implements CpuProcessSlice {
    @NotNull
    private final ProcessModelFragment process;
    @NotNull
    private final ThreadModelFragment thread;
    private final double startTime;
    private double endTime;
    private double cpuTime;

    public SchedulingProcessFragment(@NotNull ProcessModelFragment process, @NotNull ThreadModelFragment thread2, double startTime) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)thread2, (String)"thread");
        this.process = process;
        this.thread = thread2;
        this.startTime = startTime;
        this.endTime = Double.MAX_VALUE;
    }

    @NotNull
    public final ProcessModelFragment getProcess() {
        return this.process;
    }

    @NotNull
    public final ThreadModelFragment getThread() {
        return this.thread;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double d) {
        this.endTime = d;
    }

    @Override
    public double getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(double d) {
        this.cpuTime = d;
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        if (this.process.getName() != null) {
            String string2 = this.process.getName();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            string = String.valueOf(this.process.getId());
        }
        return string;
    }

    @Override
    @NotNull
    public String getThreadName() {
        if (this.thread.getName() != null) {
            String string = this.thread.getName();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return String.valueOf(this.getThreadId());
    }

    @Override
    public int getThreadId() {
        return this.thread.getId();
    }

    @Override
    public int getId() {
        return this.process.getId();
    }

    @Override
    public boolean getDidNotFinish() {
        return this.getEndTime() == Double.MAX_VALUE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Ltrebuchet/model/fragments/SchedulingProcessFragment$Builder;", "", "()V", "_slices", "", "Ltrebuchet/model/fragments/SchedulingProcessFragment;", "slices", "", "getSlices", "()Ljava/util/List;", "switchProcess", "", "process", "Ltrebuchet/model/fragments/ProcessModelFragment;", "thread", "Ltrebuchet/model/fragments/ThreadModelFragment;", "timestamp", "", "intellij.android.profilers.atrace"})
    public static final class Builder {
        @NotNull
        private final List<SchedulingProcessFragment> _slices = new ArrayList();

        @NotNull
        public final List<SchedulingProcessFragment> getSlices() {
            return this._slices;
        }

        public final void switchProcess(@NotNull ProcessModelFragment process, @NotNull ThreadModelFragment thread2, double timestamp) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter((Object)thread2, (String)"thread");
            if (!((Collection)this._slices).isEmpty() && ((SchedulingProcessFragment)CollectionsKt.last(this._slices)).getEndTime() == Double.MAX_VALUE) {
                ((SchedulingProcessFragment)CollectionsKt.last(this._slices)).setEndTime(timestamp);
            }
            if (thread2.getId() != 0) {
                this._slices.add(new SchedulingProcessFragment(process, thread2, timestamp));
            }
        }
    }
}

