/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.model.fragments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.model.SchedSlice;
import trebuchet.model.SchedulingState;
import trebuchet.model.base.SliceGroup;
import trebuchet.model.fragments.SchedulingSliceFragment;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"Ltrebuchet/model/fragments/SliceGroupBuilder;", "", "()V", "openSlices", "", "Ltrebuchet/model/fragments/SliceGroupBuilder$MutableSliceGroup;", "getOpenSlices", "()Ljava/util/List;", "slices", "getSlices", "autoCloseOpenSlices", "", "maxTimestamp", "", "beginSlice", "action", "Lkotlin/Function1;", "endSlice", "Ltrebuchet/model/base/SliceGroup;", "hasOpenSlices", "", "Companion", "MutableSliceGroup", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nSliceGroupBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SliceGroupBuilder.kt\ntrebuchet/model/fragments/SliceGroupBuilder\n*L\n1#1,127:1\n36#1,11:128\n*S KotlinDebug\n*F\n+ 1 SliceGroupBuilder.kt\ntrebuchet/model/fragments/SliceGroupBuilder\n*L\n51#1:128,11\n*E\n"})
public final class SliceGroupBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MutableSliceGroup> slices = new ArrayList();
    @NotNull
    private final List<MutableSliceGroup> openSlices = new ArrayList();
    @NotNull
    private static final List<MutableSliceGroup> EmptyChildren = new ArrayList();
    @NotNull
    private static final List<SchedulingSliceFragment> EmptySchedules = new ArrayList();

    @NotNull
    public final List<MutableSliceGroup> getSlices() {
        return this.slices;
    }

    @NotNull
    public final List<MutableSliceGroup> getOpenSlices() {
        return this.openSlices;
    }

    public final boolean hasOpenSlices() {
        return !((Collection)this.openSlices).isEmpty();
    }

    public final void beginSlice(@NotNull Function1<? super MutableSliceGroup, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$beginSlice = false;
        MutableSliceGroup builder = new MutableSliceGroup(0.0, 0.0, false, 0.0, null, null, null, 127, null);
        action.invoke((Object)builder);
        this.getOpenSlices().add(builder);
    }

    @Nullable
    public final SliceGroup endSlice(@NotNull Function1<? super MutableSliceGroup, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$endSlice = false;
        if (!this.hasOpenSlices()) {
            return null;
        }
        MutableSliceGroup builder = this.getOpenSlices().remove(CollectionsKt.getLastIndex(this.getOpenSlices()));
        action.invoke((Object)builder);
        builder.validate();
        if (!((Collection)this.getOpenSlices()).isEmpty()) {
            ((MutableSliceGroup)CollectionsKt.last(this.getOpenSlices())).add(builder);
        } else {
            this.getSlices().add(builder);
        }
        return builder;
    }

    public final void autoCloseOpenSlices(double maxTimestamp) {
        while (this.hasOpenSlices()) {
            MutableSliceGroup builder$iv;
            SliceGroupBuilder this_$iv = this;
            boolean $i$f$endSlice = false;
            if (!this_$iv.hasOpenSlices()) continue;
            MutableSliceGroup it = builder$iv = this_$iv.getOpenSlices().remove(CollectionsKt.getLastIndex(this_$iv.getOpenSlices()));
            boolean bl = false;
            it.setEndTime(maxTimestamp);
            it.setDidNotFinish(true);
            builder$iv.validate();
            if (!((Collection)this_$iv.getOpenSlices()).isEmpty()) {
                ((MutableSliceGroup)CollectionsKt.last(this_$iv.getOpenSlices())).add(builder$iv);
            } else {
                this_$iv.getSlices().add(builder$iv);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ltrebuchet/model/fragments/SliceGroupBuilder$Companion;", "", "()V", "EmptyChildren", "", "Ltrebuchet/model/fragments/SliceGroupBuilder$MutableSliceGroup;", "getEmptyChildren", "()Ljava/util/List;", "EmptySchedules", "Ltrebuchet/model/fragments/SchedulingSliceFragment;", "getEmptySchedules", "intellij.android.profilers.atrace"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<MutableSliceGroup> getEmptyChildren() {
            return EmptyChildren;
        }

        @NotNull
        public final List<SchedulingSliceFragment> getEmptySchedules() {
            return EmptySchedules;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B]\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000b\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0000J\u0014\u0010+\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\u0010J\u0006\u0010-\u001a\u00020)R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R$\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016\u00a8\u0006."}, d2={"Ltrebuchet/model/fragments/SliceGroupBuilder$MutableSliceGroup;", "Ltrebuchet/model/base/SliceGroup;", "startTime", "", "endTime", "didNotFinish", "", "cpuTime", "_name", "", "_children", "", "_scheduledSlices", "Ltrebuchet/model/fragments/SchedulingSliceFragment;", "(DDZDLjava/lang/String;Ljava/util/List;Ljava/util/List;)V", "children", "", "getChildren", "()Ljava/util/List;", "getCpuTime", "()D", "setCpuTime", "(D)V", "getDidNotFinish", "()Z", "setDidNotFinish", "(Z)V", "getEndTime", "setEndTime", "value", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "scheduledSlices", "Ltrebuchet/model/SchedSlice;", "getScheduledSlices", "getStartTime", "setStartTime", "add", "", "child", "populateScheduledSlices", "slices", "validate", "intellij.android.profilers.atrace"})
    public static final class MutableSliceGroup
    implements SliceGroup {
        private double startTime;
        private double endTime;
        private boolean didNotFinish;
        private double cpuTime;
        @Nullable
        private String _name;
        @Nullable
        private List<MutableSliceGroup> _children;
        @Nullable
        private List<SchedulingSliceFragment> _scheduledSlices;

        public MutableSliceGroup(double startTime, double endTime, boolean didNotFinish, double cpuTime, @Nullable String _name, @Nullable List<MutableSliceGroup> _children, @Nullable List<SchedulingSliceFragment> _scheduledSlices) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.didNotFinish = didNotFinish;
            this.cpuTime = cpuTime;
            this._name = _name;
            this._children = _children;
            this._scheduledSlices = _scheduledSlices;
        }

        public /* synthetic */ MutableSliceGroup(double d, double d2, boolean bl, double d3, String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = Double.NaN;
            }
            if ((n & 2) != 0) {
                d2 = Double.NaN;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                d3 = 0.0;
            }
            if ((n & 0x10) != 0) {
                string = null;
            }
            if ((n & 0x20) != 0) {
                list = null;
            }
            if ((n & 0x40) != 0) {
                list2 = null;
            }
            this(d, d2, bl, d3, string, list, list2);
        }

        @Override
        public double getStartTime() {
            return this.startTime;
        }

        public void setStartTime(double d) {
            this.startTime = d;
        }

        @Override
        public double getEndTime() {
            return this.endTime;
        }

        public void setEndTime(double d) {
            this.endTime = d;
        }

        @Override
        public boolean getDidNotFinish() {
            return this.didNotFinish;
        }

        public void setDidNotFinish(boolean bl) {
            this.didNotFinish = bl;
        }

        @Override
        public double getCpuTime() {
            return this.cpuTime;
        }

        public void setCpuTime(double d) {
            this.cpuTime = d;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this._name;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        public void setName(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this._name = value;
        }

        @Override
        @NotNull
        public List<SchedSlice> getScheduledSlices() {
            List<SchedSlice> list = this._scheduledSlices;
            Intrinsics.checkNotNull(list);
            return list;
        }

        @Override
        @NotNull
        public List<SliceGroup> getChildren() {
            List<SliceGroup> list = this._children;
            Intrinsics.checkNotNull(list);
            return list;
        }

        public final void validate() {
            double d = this.getStartTime();
            if (!(!Double.isInfinite(d) && !Double.isNaN(d)) || this.getStartTime() < 0.0) {
                throw new IllegalStateException("Invalid startTime " + this.getStartTime());
            }
            d = this.getEndTime();
            if (!(!Double.isInfinite(d) && !Double.isNaN(d)) || this.getEndTime() < 0.0) {
                throw new IllegalStateException("Invalid endTime " + this.getEndTime());
            }
            if (this.getEndTime() < this.getStartTime()) {
                throw new IllegalStateException("endTime " + this.getEndTime() + " cannot be before startTime " + this.getStartTime());
            }
            if (this._name == null) {
                throw new IllegalStateException("name cannot be null");
            }
            if (this._children == null) {
                this._children = Companion.getEmptyChildren();
            }
            if (this._scheduledSlices == null) {
                this._scheduledSlices = Companion.getEmptySchedules();
            }
        }

        public final void populateScheduledSlices(@NotNull List<SchedulingSliceFragment> slices) {
            Intrinsics.checkNotNullParameter(slices, (String)"slices");
            for (int i = slices.size() - 1; -1 < i && !(slices.get(i).getEndTime() < this.getStartTime()); --i) {
                if (slices.get(i).getState() != SchedulingState.RUNNING || !(slices.get(i).getStartTime() < this.getEndTime())) continue;
                this.setCpuTime(this.getCpuTime() + (Math.min(slices.get(i).getEndTime(), this.getEndTime()) - Math.max(slices.get(i).getStartTime(), this.getStartTime())));
                if (this._scheduledSlices == null) {
                    this._scheduledSlices = new ArrayList();
                }
                List<SchedulingSliceFragment> list = this._scheduledSlices;
                Intrinsics.checkNotNull(list);
                list.add(slices.get(i));
            }
        }

        public final void add(@NotNull MutableSliceGroup child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (this._children == null) {
                this._children = new ArrayList();
            }
            List<MutableSliceGroup> list = this._children;
            Intrinsics.checkNotNull(list);
            list.add(child);
        }

        public MutableSliceGroup() {
            this(0.0, 0.0, false, 0.0, null, null, null, 127, null);
        }
    }
}

