/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.ngram;

import ai.grazie.detector.ngram.WordBloomFilter;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0006\u0010\t\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"dir", "", "generateBloom", "", "lang", "wordFile", "Ljava/nio/file/Path;", "nbits", "", "main", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nBloomEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BloomEncoder.kt\nai/grazie/detector/ngram/BloomEncoderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n766#2:60\n857#2,2:61\n1855#2,2:63\n1855#2,2:65\n1855#2,2:67\n*S KotlinDebug\n*F\n+ 1 BloomEncoder.kt\nai/grazie/detector/ngram/BloomEncoderKt\n*L\n43#1:60\n43#1:61,2\n48#1:63,2\n51#1:65,2\n55#1:67,2\n*E\n"})
public final class BloomEncoderKt {
    @NotNull
    private static final String dir = "insert_your_dir_here";

    public static final void main() {
        HashSet commonWords = new HashSet();
        Object[] objectArray = new String[]{"ru", "uk"};
        for (String lang : CollectionsKt.listOf((Object[])objectArray)) {
            Path wordFile = Path.of(dir + "/" + lang + "_words.txt", new String[0]);
            if (commonWords.isEmpty()) {
                commonWords.addAll(Files.readAllLines(wordFile));
            } else {
                List<String> list = Files.readAllLines(wordFile);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(wordFile)");
                commonWords.retainAll(CollectionsKt.toSet((Iterable)list));
            }
            Intrinsics.checkNotNullExpressionValue((Object)wordFile, (String)"wordFile");
            BloomEncoderKt.generateBloom(lang, wordFile, 360000);
        }
        System.out.println((Object)(commonWords.size() + " common words"));
    }

    /*
     * Unable to fully structure code
     */
    private static final void generateBloom(String lang, Path wordFile, int nbits) {
        letterWord = new Regex("\\p{L}+");
        v0 = Files.readAllLines(wordFile);
        Intrinsics.checkNotNullExpressionValue(v0, (String)"readAllLines(wordFile)");
        var5_4 = v0;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-BloomEncoderKt$generateBloom$words$1 = false;
            if (it.length() > 10) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (letterWord.matches((CharSequence)it)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        words = (List)destination$iv$iv;
        filter = new WordBloomFilter(BigInteger.valueOf(nbits).nextProbablePrime().intValue());
        added = new HashSet<E>();
        $this$forEach$iv = words;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            $i$a$-forEach-BloomEncoderKt$generateBloom$1 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            added.addAll(filter.add(it));
        }
        System.out.println((Object)(lang + ": " + words.size() + " words, " + added.size() + " entries added, saturation " + filter.saturation() * (double)100 + "%"));
        $this$forEach$iv = words;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            $i$a$-forEach-BloomEncoderKt$generateBloom$2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (filter.mayContain(it)) continue;
            $i$a$-filter-BloomEncoderKt$generateBloom$words$1 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-filter-BloomEncoderKt$generateBloom$words$1.toString());
        }
        serialized = filter.serialize();
        restored = WordBloomFilter.Companion.deserialize$nlp_detect(serialized);
        $this$forEach$iv = words;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            $i$a$-forEach-BloomEncoderKt$generateBloom$3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (restored.mayContain(it)) continue;
            var15_25 = "Failed requirement.";
            throw new IllegalArgumentException(var15_25.toString());
        }
        Files.write(Path.of("nlp/nlp-detect/src/commonMain/resources/bloom/" + lang + ".bin", new String[0]), serialized, new OpenOption[0]);
    }

    public static /* synthetic */ void main(String[] args) {
        BloomEncoderKt.main();
    }
}

