/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private static final Key<QuoteInfo> QUOTE_INSERTED_AT = new Key("xml.eq-handler.inserted-quote");
    private boolean needToInsertQuotes = false;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Caret currentCaret;
        QuoteInfo quoteInsertedAt;
        if (project2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(3);
        }
        if ((quoteInsertedAt = (QuoteInfo)(currentCaret = editor.getCaretModel().getCurrentCaret()).getUserData(QUOTE_INSERTED_AT)) != null) {
            currentCaret.putUserData(QUOTE_INSERTED_AT, null);
        }
        if ((c == '\"' || c == '\'' && HtmlUtil.hasHtml(file)) && quoteInsertedAt != null && quoteInsertedAt.position == currentCaret.getOffset() && quoteInsertedAt.quote != '{') {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                XmlEqTypedHandler.$$$reportNull$$$0(4);
            }
            return result2;
        }
        if (c == '=' && WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && XmlGtTypedHandler.fileContainsXmlLanguage(file)) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            PsiElement atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file, false);
            if (atParent instanceof XmlAttribute && ((XmlAttribute)atParent).getValueElement() == null) {
                this.needToInsertQuotes = ((XmlAttribute)atParent).getValueElement() == null;
            }
        }
        TypedHandlerDelegate.Result result3 = super.beforeCharTyped(c, project2, editor, file, fileType);
        if (result3 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(5);
        }
        return result3;
    }

    @Nullable
    private static PsiElement getAttributeCandidate(@NotNull Editor editor, @NotNull PsiFile file, boolean typed) {
        int newOffset;
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(7);
        }
        if ((newOffset = editor.getCaretModel().getOffset() - (typed ? 2 : 1)) < 0) {
            return null;
        }
        PsiElement at = file.findElementAt(newOffset);
        return at != null ? at.getParent() : null;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(10);
        }
        if (this.needToInsertQuotes) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement fileContext = file.getContext();
            Object toInsert = XmlEqTypedHandler.tryCompleteQuotes(fileContext);
            boolean showPopup2 = true;
            boolean showParameterInfo = false;
            if (toInsert == null) {
                String quote = XmlEqTypedHandler.getDefaultQuote(file);
                XmlExtension.AttributeValuePresentation presentation2 = XmlEqTypedHandler.getValuePresentation(editor, file, quote);
                toInsert = presentation2.getPrefix() + presentation2.getPostfix();
                showPopup2 = presentation2.showAutoPopup();
                showParameterInfo = "{}".equals(toInsert);
            }
            editor.getDocument().insertString(offset, (CharSequence)toInsert);
            editor.getCaretModel().moveToOffset(offset + ((String)toInsert).length() / 2);
            if (showPopup2) {
                AutoPopupController.getInstance((Project)project2).scheduleAutoPopup(editor);
            }
            if (showParameterInfo) {
                AutoPopupController.getInstance((Project)project2).autoPopupParameterInfo(editor, null);
            }
            this.needToInsertQuotes = false;
            Caret caret = editor.getCaretModel().getCurrentCaret();
            caret.putUserData(QUOTE_INSERTED_AT, (Object)(((String)toInsert).isEmpty() ? null : new QuoteInfo(((String)toInsert).charAt(0), caret.getOffset())));
        }
        TypedHandlerDelegate.Result result2 = super.charTyped(c, project2, editor, file);
        if (result2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(11);
        }
        return result2;
    }

    @Nullable
    private static String tryCompleteQuotes(@Nullable PsiElement fileContext) {
        if (fileContext != null) {
            if (fileContext.getText().startsWith("\"")) {
                return "''";
            }
            if (fileContext.getText().startsWith("'")) {
                return "\"\"";
            }
        }
        return null;
    }

    @NotNull
    private static String getDefaultQuote(@NotNull PsiFile file) {
        if (file == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(12);
        }
        String string2 = XmlEditUtil.getAttributeQuote(file);
        if (string2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation getValuePresentation(@NotNull Editor editor, @NotNull PsiFile file, @NotNull String quote) {
        PsiElement atParent;
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(14);
        }
        if (file == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(15);
        }
        if (quote == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(16);
        }
        if ((atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file, true)) instanceof XmlAttribute) {
            XmlTag parent = ((XmlAttribute)atParent).getParent();
            XmlExtension.AttributeValuePresentation attributeValuePresentation = XmlExtension.getExtension(file).getAttributeValuePresentation(parent, ((XmlAttribute)atParent).getName(), quote);
            if (attributeValuePresentation == null) {
                XmlEqTypedHandler.$$$reportNull$$$0(17);
            }
            return attributeValuePresentation;
        }
        XmlExtension.AttributeValuePresentation attributeValuePresentation = XmlExtension.getExtension(file).getAttributeValuePresentation(null, "", quote);
        if (attributeValuePresentation == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(18);
        }
        return attributeValuePresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 11, 13, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlEqTypedHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlEqTypedHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultQuote";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeCandidate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultQuote";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValuePresentation";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 11, 13, 17, 18 -> new IllegalStateException(string2);
        };
    }

    private record QuoteInfo(char quote, int position) {
    }
}

