/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.details;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.codereview.details.data.ReviewRequestState;
import com.intellij.collaboration.ui.codereview.details.data.ReviewState;
import com.intellij.icons.AllIcons;
import com.intellij.icons.ExpUiIcons;
import com.intellij.ui.ExperimentalUI;
import java.awt.Insets;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001b\u0010$\u001a\u00070\u001c\u00a2\u0006\u0002\b%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001cR\u0017\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007R\u0017\u0010\u0011\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/intellij/collaboration/ui/codereview/details/ReviewDetailsUIUtil;", "", "()V", "ACTIONS_GAPS", "Ljava/awt/Insets;", "getACTIONS_GAPS$annotations", "getACTIONS_GAPS", "()Ljava/awt/Insets;", "COMMIT_INFO_GAPS", "getCOMMIT_INFO_GAPS$annotations", "getCOMMIT_INFO_GAPS", "COMMIT_POPUP_BRANCHES_GAPS", "getCOMMIT_POPUP_BRANCHES_GAPS$annotations", "getCOMMIT_POPUP_BRANCHES_GAPS", "DESCRIPTION_GAPS", "getDESCRIPTION_GAPS$annotations", "getDESCRIPTION_GAPS", "STATUSES_GAPS", "getSTATUSES_GAPS$annotations", "getSTATUSES_GAPS", "STATUSES_MAX_HEIGHT", "", "getSTATUSES_MAX_HEIGHT", "()I", "TITLE_GAPS", "getTITLE_GAPS$annotations", "getTITLE_GAPS", "getRequestStateText", "", "Lcom/intellij/openapi/util/NlsSafe;", "state", "Lcom/intellij/collaboration/ui/codereview/details/data/ReviewRequestState;", "getReviewStateIcon", "Ljavax/swing/Icon;", "reviewState", "Lcom/intellij/collaboration/ui/codereview/details/data/ReviewState;", "getReviewStateText", "Lorg/jetbrains/annotations/Nls;", "reviewer", "intellij.platform.collaborationTools"})
public final class ReviewDetailsUIUtil {
    @NotNull
    public static final ReviewDetailsUIUtil INSTANCE = new ReviewDetailsUIUtil();

    private ReviewDetailsUIUtil() {
    }

    @NotNull
    public final String getRequestStateText(@NotNull ReviewRequestState state) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                String string3 = CollaborationToolsBundle.message("review.details.review.state.open", new Object[0]);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"review.details.review.state.open\")");
                break;
            }
            case 2: {
                String string4 = CollaborationToolsBundle.message("review.details.review.state.closed", new Object[0]);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"review.details.review.state.closed\")");
                break;
            }
            case 3: {
                String string5 = CollaborationToolsBundle.message("review.details.review.state.merged", new Object[0]);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"review.details.review.state.merged\")");
                break;
            }
            case 4: {
                String string6 = CollaborationToolsBundle.message("review.details.review.state.draft", new Object[0]);
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"review.details.review.state.draft\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public final Icon getReviewStateIcon(@NotNull ReviewState reviewState) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)((Object)reviewState), (String)"reviewState");
        switch (WhenMappings.$EnumSwitchMapping$1[reviewState.ordinal()]) {
            case 1: {
                Icon icon3 = ExperimentalUI.isNewUI() ? ExpUiIcons.Status.Success : AllIcons.RunConfigurations.TestPassed;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"if (ExperimentalUI.isNew\u2026Configurations.TestPassed");
                break;
            }
            case 2: {
                Icon icon4 = ExperimentalUI.isNewUI() ? ExpUiIcons.Status.Error : AllIcons.RunConfigurations.TestError;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"if (ExperimentalUI.isNew\u2026nConfigurations.TestError");
                break;
            }
            case 3: {
                Icon icon5 = ExperimentalUI.isNewUI() ? ExpUiIcons.Status.Warning : AllIcons.RunConfigurations.TestFailed;
                icon2 = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"if (ExperimentalUI.isNew\u2026Configurations.TestFailed");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon2;
    }

    @NotNull
    public final String getReviewStateText(@NotNull ReviewState reviewState, @NotNull String reviewer) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)reviewState), (String)"reviewState");
        Intrinsics.checkNotNullParameter((Object)reviewer, (String)"reviewer");
        switch (WhenMappings.$EnumSwitchMapping$1[reviewState.ordinal()]) {
            case 1: {
                Object[] objectArray = new Object[]{reviewer};
                String string3 = CollaborationToolsBundle.message("review.details.status.reviewer.approved", objectArray);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"review.details.\u2026ewer.approved\", reviewer)");
                break;
            }
            case 2: {
                Object[] objectArray = new Object[]{reviewer};
                String string4 = CollaborationToolsBundle.message("review.details.status.reviewer.wait.for.updates", objectArray);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"review.details.\u2026t.for.updates\", reviewer)");
                break;
            }
            case 3: {
                Object[] objectArray = new Object[]{reviewer};
                String string5 = CollaborationToolsBundle.message("review.details.status.reviewer.need.review", objectArray);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"review.details.\u2026r.need.review\", reviewer)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public final Insets getTITLE_GAPS() {
        return CollaborationToolsUIUtil.INSTANCE.getInsets(new Insets(12, 13, 8, 13), new Insets(16, 17, 8, 13));
    }

    public static /* synthetic */ void getTITLE_GAPS$annotations() {
    }

    @NotNull
    public final Insets getDESCRIPTION_GAPS() {
        return CollaborationToolsUIUtil.INSTANCE.getInsets(new Insets(0, 13, 18, 13), new Insets(0, 17, 22, 13));
    }

    public static /* synthetic */ void getDESCRIPTION_GAPS$annotations() {
    }

    @NotNull
    public final Insets getCOMMIT_POPUP_BRANCHES_GAPS() {
        return CollaborationToolsUIUtil.INSTANCE.getInsets(new Insets(0, 13, 9, 13), new Insets(0, 17, 15, 13));
    }

    public static /* synthetic */ void getCOMMIT_POPUP_BRANCHES_GAPS$annotations() {
    }

    @NotNull
    public final Insets getCOMMIT_INFO_GAPS() {
        return CollaborationToolsUIUtil.INSTANCE.getInsets(new Insets(0, 13, 12, 13), new Insets(0, 17, 12, 13));
    }

    public static /* synthetic */ void getCOMMIT_INFO_GAPS$annotations() {
    }

    @NotNull
    public final Insets getSTATUSES_GAPS() {
        return CollaborationToolsUIUtil.INSTANCE.getInsets(new Insets(6, 13, 10, 13), new Insets(6, 17, 10, 13));
    }

    public static /* synthetic */ void getSTATUSES_GAPS$annotations() {
    }

    @NotNull
    public final Insets getACTIONS_GAPS() {
        return CollaborationToolsUIUtil.INSTANCE.getInsets(new Insets(0, 11, 15, 13), new Insets(0, 15, 18, 13));
    }

    public static /* synthetic */ void getACTIONS_GAPS$annotations() {
    }

    public final int getSTATUSES_MAX_HEIGHT() {
        return CollaborationToolsUIUtil.INSTANCE.getSize(143, 149);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ReviewRequestState.values().length];
            try {
                nArray[ReviewRequestState.OPENED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewRequestState.CLOSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewRequestState.MERGED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewRequestState.DRAFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReviewState.values().length];
            try {
                nArray[ReviewState.ACCEPTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewState.WAIT_FOR_UPDATES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewState.NEED_REVIEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

