/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Block {
    private static final Logger LOG = Logger.getInstance(Block.class);
    private final String @NotNull [] mySource;
    private final int myStart;
    private final int myEnd;

    public Block(@NotNull String source2, int start2, int end) {
        if (source2 == null) {
            Block.$$$reportNull$$$0(0);
        }
        this(Block.tokenize(source2), start2, end);
    }

    public Block(String @NotNull [] source2, int start2, int end) {
        if (source2 == null) {
            Block.$$$reportNull$$$0(1);
        }
        this.mySource = source2;
        this.myStart = DiffUtil.bound((int)start2, (int)0, (int)source2.length);
        this.myEnd = DiffUtil.bound((int)end, (int)this.myStart, (int)source2.length);
    }

    public static String @NotNull [] tokenize(@NotNull String text2) {
        if (text2 == null) {
            Block.$$$reportNull$$$0(2);
        }
        String[] stringArray = LineTokenizer.tokenize((CharSequence)text2, (boolean)false, (boolean)false);
        if (stringArray == null) {
            Block.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String prevContent) {
        if (prevContent == null) {
            Block.$$$reportNull$$$0(4);
        }
        Block block = this.createPreviousBlock(Block.tokenize(prevContent));
        if (block == null) {
            Block.$$$reportNull$$$0(5);
        }
        return block;
    }

    @NotNull
    public Block createPreviousBlock(String @NotNull [] prevContent) {
        if (prevContent == null) {
            Block.$$$reportNull$$$0(6);
        }
        try {
            FairDiffIterable iterable = ByLine.compare(Arrays.asList(prevContent), Arrays.asList(this.mySource), (ComparisonPolicy)ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            boolean greedy = this.myStart != this.myEnd;
            int start2 = this.myStart;
            int end = this.myEnd;
            int shift = 0;
            for (Range range : iterable.iterateChanges()) {
                int changeStart = range.start2 + shift;
                int changeEnd = range.end2 + shift;
                int changeShift = range.end1 - range.start1 - (range.end2 - range.start2);
                DiffUtil.UpdatedLineRange updatedRange = DiffUtil.updateRangeOnModification((int)start2, (int)end, (int)changeStart, (int)changeEnd, (int)changeShift, (boolean)greedy);
                start2 = updatedRange.startLine;
                end = updatedRange.endLine;
                shift += changeShift;
            }
            if (start2 < 0 || end > prevContent.length || end < start2) {
                LOG.error("Invalid block range: [" + start2 + ", " + end + "); length - " + prevContent.length);
            }
            for (Range range : iterable.iterateUnchanged()) {
                int count = range.end1 - range.start1;
                for (int i = 0; i < count; ++i) {
                    int prevIndex = range.start1 + i;
                    int sourceIndex = range.start2 + i;
                    if (!prevContent[prevIndex].equals(this.mySource[sourceIndex])) continue;
                    prevContent[prevIndex] = this.mySource[sourceIndex];
                }
            }
            return new Block(prevContent, start2, end);
        }
        catch (DiffTooBigException e) {
            return new Block(prevContent, 0, 0);
        }
    }

    @NotNull
    public String getBlockContent() {
        String string2 = StringUtil.join(this.getLines(), (String)"\n");
        if (string2 == null) {
            Block.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    public List<String> getLines() {
        List<String> list = Arrays.asList(this.mySource).subList(this.myStart, this.myEnd);
        if (list == null) {
            Block.$$$reportNull$$$0(8);
        }
        return list;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mySource) ^ this.myStart ^ this.myEnd;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return this.myStart == other.myStart && this.myEnd == other.myEnd && Arrays.equals(this.mySource, other.mySource);
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        this.appendLines(result2, 0, this.myStart);
        result2.append("<-----------------------------\n");
        this.appendLines(result2, this.myStart, this.myEnd);
        result2.append("----------------------------->\n");
        this.appendLines(result2, this.myEnd, this.mySource.length);
        return result2.toString();
    }

    private void appendLines(@NotNull StringBuilder result2, int from, int to) {
        if (result2 == null) {
            Block.$$$reportNull$$$0(9);
        }
        for (int i = from; i < to; ++i) {
            result2.append(this.mySource[i]);
            result2.append("\n");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/Block";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevContent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/Block";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviousBlock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPreviousBlock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendLines";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

