/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.ui.DocumentAdapter;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle;", "Lcom/intellij/ui/DocumentAdapter;", "document", "Ljavax/swing/text/Document;", "defaultParentPath", "Ljava/nio/file/Path;", "(Ljavax/swing/text/Document;Ljava/nio/file/Path;)V", "modifiedByUser", "", "textChanged", "", "e", "Ljavax/swing/event/DocumentEvent;", "trySetChildPath", "child", "", "Companion", "intellij.platform.vcs.dvcs.impl"})
public final class FilePathDocumentChildPathHandle
extends DocumentAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @NotNull
    private final Path defaultParentPath;
    private boolean modifiedByUser;

    private FilePathDocumentChildPathHandle(Document document2, Path defaultParentPath) {
        this.document = document2;
        this.defaultParentPath = defaultParentPath;
        this.document.remove(0, this.document.getLength());
        this.document.insertString(0, ((Object)this.defaultParentPath).toString(), null);
    }

    protected void textChanged(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.modifiedByUser = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trySetChildPath(@NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (!this.modifiedByUser) {
            try {
                Path newPath = this.defaultParentPath.resolve(child);
                this.document.remove(0, this.document.getLength());
                this.document.insertString(0, ((Object)newPath).toString(), null);
            }
            catch (InvalidPathException invalidPathException) {
            }
            finally {
                this.modifiedByUser = false;
            }
        }
    }

    public /* synthetic */ FilePathDocumentChildPathHandle(Document document2, Path defaultParentPath, DefaultConstructorMarker $constructor_marker) {
        this(document2, defaultParentPath);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle$Companion;", "", "()V", "install", "Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle;", "document", "Ljavax/swing/text/Document;", "defaultParentPath", "", "intellij.platform.vcs.dvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FilePathDocumentChildPathHandle install(@NotNull Document document2, @NotNull String defaultParentPath) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            Intrinsics.checkNotNullParameter((Object)defaultParentPath, (String)"defaultParentPath");
            Path path2 = Paths.get(defaultParentPath, new String[0]).toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(defaultParentPath).toAbsolutePath()");
            FilePathDocumentChildPathHandle handle = new FilePathDocumentChildPathHandle(document2, path2, null);
            document2.addDocumentListener((DocumentListener)((Object)handle));
            return handle;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

